/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.security.symmetric;

import com.feilong.core.lang.StringUtil;
import com.feilong.core.util.MapUtil;
import com.feilong.json.JsonUtil;
import com.feilong.lib.lang3.StringUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LogBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogBuilder.class);

    private LogBuilder() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static void logEncrypt(String typeName, String original, String value, String algorithm, String keyString) {
        if (LOGGER.isDebugEnabled()) {
            Map<String, String> map = MapUtil.newLinkedHashMap();
            map.put("algorithm", algorithm);
            map.put("keyString", LogBuilder.hided(keyString));
            map.put("original", original);
            map.put(typeName, value);
            map.put("valueLength", "" + value.length());
            LOGGER.debug(JsonUtil.format(map));
        }
    }

    static void logDecrypt(String typeName, String needDecryptValue, String original, String algorithm, String keyString) {
        if (LOGGER.isDebugEnabled()) {
            Map<String, String> map = MapUtil.newLinkedHashMap();
            map.put("algorithm", algorithm);
            map.put("keyString", LogBuilder.hided(keyString));
            map.put(typeName, needDecryptValue);
            map.put("original", original);
            LOGGER.debug(JsonUtil.format(map));
        }
    }

    static String errorMessage(String typeName, String value, String algorithm, String keyString, String charsetName) {
        Map<String, String> map = MapUtil.newLinkedHashMap();
        map.put("algorithm", algorithm);
        map.put("keyString", LogBuilder.hided(keyString));
        map.put(typeName, value);
        map.put("charsetName", charsetName);
        return JsonUtil.format(map);
    }

    private static String hided(String keyString) {
        int length = keyString.length();
        if (length <= 3) {
            return "*";
        }
        if (length == 4) {
            return StringUtil.substring(keyString, 0, 1) + StringUtils.repeat("*", length - 1);
        }
        if (length == 5) {
            return StringUtil.substring(keyString, 0, 2) + StringUtils.repeat("*", length - 2);
        }
        return StringUtil.substring(keyString, 0, 1) + StringUtils.repeat("*", length - 3) + StringUtil.substringLast(keyString, 2);
    }
}

