/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.security.symmetric;

import com.feilong.security.EncryptionException;
import com.feilong.tools.slf4j.Slf4jUtil;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class CipherUtil {
    private CipherUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static byte[] encrypt(byte[] bytes, String transformation, Key key) {
        return CipherUtil.opBytes(bytes, 1, transformation, key);
    }

    public static byte[] decrypt(byte[] bytes, String transformation, Key key) {
        return CipherUtil.opBytes(bytes, 2, transformation, key);
    }

    private static byte[] opBytes(byte[] bytes, int opmode, String transformation, Key key) {
        try {
            Cipher cipher = Cipher.getInstance(transformation);
            cipher.init(opmode, key);
            return cipher.doFinal(bytes);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new EncryptionException(Slf4jUtil.format("opmode:[{}],transformation:[{}]", opmode, transformation), e);
        }
    }
}

