/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.net.jsoup;

import com.feilong.core.Validate;
import com.feilong.net.jsoup.JsoupUtilException;
import com.feilong.tools.slf4j.Slf4jUtil;
import java.io.IOException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public final class JsoupUtil {
    public static final int DEFAULT_TIMEOUT_MILLIS = 20000;
    private static final String DEFAULT_USER_AGENT = "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.21 (KHTML, like Gecko) Chrome/19.0.1042.0 Safari/535.21";

    private JsoupUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static Document getDocument(String urlString) {
        return JsoupUtil.getDocument(urlString, DEFAULT_USER_AGENT);
    }

    public static Document parse(String html) {
        Validate.notNull(html, "html can't be null!", new Object[0]);
        return Jsoup.parse((String)html);
    }

    public static Document getDocument(String urlString, String userAgent) {
        try {
            return Jsoup.connect((String)urlString).userAgent(userAgent).timeout(20000).get();
        }
        catch (IOException e) {
            throw new JsoupUtilException(Slf4jUtil.format("urlString:[{}],userAgent:[{}]", urlString, userAgent), e);
        }
    }

    public static Elements getElementsBySelect(String url, String selectQuery) {
        Validate.notBlank(url, "url can't be blank!", new Object[0]);
        Validate.notBlank(selectQuery, "selectQuery can't be blank!", new Object[0]);
        Document document = JsoupUtil.getDocument(url);
        return document.select(selectQuery);
    }

    public static Element getElementById(String url, String id) {
        Validate.notBlank(url, "url can't be blank!", new Object[0]);
        Validate.notBlank(id, "id can't be blank!", new Object[0]);
        Document document = JsoupUtil.getDocument(url);
        return document.getElementById(id);
    }
}

