/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.net.http.packer;

import com.feilong.core.Validator;
import com.feilong.net.http.ConnectionConfig;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpRequestHeadersPacker {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequestHeadersPacker.class);

    private HttpRequestHeadersPacker() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static void setHeaders(HttpUriRequest httpUriRequest, Map<String, String> headerMap, ConnectionConfig connectionConfig) {
        HttpRequestHeadersPacker.setDefaultHeader(httpUriRequest);
        HttpRequestHeadersPacker.setBasicAuthenticationHeader(httpUriRequest, connectionConfig);
        HttpRequestHeadersPacker.setHeaderMap(httpUriRequest, headerMap);
    }

    private static void setHeaderMap(HttpUriRequest httpUriRequest, Map<String, String> headerMap) {
        if (Validator.isNullOrEmpty(headerMap)) {
            LOGGER.trace("input [headerMap] is null or empty ,skip!");
            return;
        }
        for (Map.Entry<String, String> entry : headerMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            httpUriRequest.setHeader(key, value);
            if (!LOGGER.isTraceEnabled()) continue;
            LOGGER.trace("httpUriRequest.setHeader({}, {})", (Object)key, (Object)value);
        }
    }

    private static void setBasicAuthenticationHeader(HttpUriRequest httpUriRequest, ConnectionConfig connectionConfig) {
        String userName = connectionConfig.getUserName();
        String password = connectionConfig.getPassword();
        if (Validator.isNotNullOrEmpty(userName) && Validator.isNotNullOrEmpty(password)) {
            String auth = userName + ":" + password;
            String authHeader = "Basic " + new String(Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.US_ASCII)));
            httpUriRequest.setHeader("Authorization", authHeader);
        }
    }

    private static void setDefaultHeader(HttpUriRequest httpUriRequest) {
        httpUriRequest.setHeader("User-Agent", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.21 (KHTML, like Gecko) Chrome/19.0.1042.0 Safari/535.21");
    }
}

