/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.net.http.builder;

import com.feilong.core.Validator;
import com.feilong.core.lang.ClassUtil;
import com.feilong.core.lang.SystemUtil;
import com.feilong.core.util.MapUtil;
import com.feilong.json.JsonUtil;
import com.feilong.net.http.ConnectionConfig;
import com.feilong.net.http.HttpRequest;
import com.feilong.tools.slf4j.Slf4jUtil;
import java.net.SocketTimeoutException;
import java.util.Map;
import javax.net.ssl.SSLException;
import org.apache.http.client.HttpClient;

public class HttpRequestExecuterExceptionMessageBuilder {
    private HttpRequestExecuterExceptionMessageBuilder() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static String build(HttpClient httpClient, HttpRequest httpRequest, ConnectionConfig useConnectionConfig, Exception e) {
        String handlerMessage = HttpRequestExecuterExceptionMessageBuilder.buildHandlerMessage(e, useConnectionConfig);
        String result = HttpRequestExecuterExceptionMessageBuilder.commonMessage(httpRequest, useConnectionConfig);
        if (Validator.isNullOrEmpty(handlerMessage)) {
            return result;
        }
        return Slf4jUtil.format("[{}],{}", handlerMessage, result);
    }

    private static String buildHandlerMessage(Exception e, ConnectionConfig useConnectionConfig) {
        if (ClassUtil.isInstance(e, SocketTimeoutException.class)) {
            StringBuilder sb = new StringBuilder();
            sb.append("current ConnectTimeout:").append(useConnectionConfig.getConnectTimeout());
            sb.append(",ReadTimeout:").append(useConnectionConfig.getReadTimeout());
            return sb.toString();
        }
        if (ClassUtil.isInstance(e, SSLException.class)) {
            return "";
        }
        return "";
    }

    private static String commonMessage(HttpRequest httpRequest, ConnectionConfig useConnectionConfig) {
        Map<String, String> httpPropertiesMap = HttpRequestExecuterExceptionMessageBuilder.buildHttpPropertiesMap();
        String pattern = "httpRequest:[{}],useConnectionConfig:[{}]";
        String commonResult = Slf4jUtil.format(pattern, JsonUtil.format(httpRequest), JsonUtil.format((Object)useConnectionConfig, true));
        if (Validator.isNullOrEmpty(httpPropertiesMap)) {
            return commonResult;
        }
        return Slf4jUtil.format("{},http system properties:[{}]", commonResult, JsonUtil.format(httpPropertiesMap));
    }

    private static Map<String, String> buildHttpPropertiesMap() {
        Map<String, String> propertiesMap = SystemUtil.getPropertiesMap();
        return MapUtil.getSubMap(propertiesMap, "http.nonProxyHosts", "java.protocol.handler.pkgs", "javax.net.ssl.trustStore", "javax.net.ssl.trustStorePassword", "socksNonProxyHosts");
    }
}

