/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.net.http.builder;

import com.feilong.core.Validate;
import com.feilong.core.date.DateUtil;
import com.feilong.core.lang.ObjectUtil;
import com.feilong.net.UncheckedHttpException;
import com.feilong.net.http.ConnectionConfig;
import com.feilong.net.http.HttpRequest;
import com.feilong.net.http.builder.HttpClientBuilder;
import com.feilong.net.http.builder.HttpRequestExecuterExceptionMessageBuilder;
import com.feilong.net.http.builder.HttpUriRequestBuilder;
import com.feilong.net.http.callback.ResultCallback;
import java.util.Date;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;

public final class HttpRequestExecuter {
    private HttpRequestExecuter() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static <T> T execute(HttpRequest httpRequest, ConnectionConfig connectionConfig, ResultCallback<T> resultCallback) {
        Validate.notNull(resultCallback, "resultCallback can't be null!", new Object[0]);
        Date beginDate = DateUtil.now();
        ConnectionConfig useConnectionConfig = ObjectUtil.defaultIfNull(connectionConfig, ConnectionConfig.INSTANCE);
        HttpUriRequest httpUriRequest = HttpUriRequestBuilder.build(httpRequest, useConnectionConfig);
        HttpResponse httpResponse = HttpRequestExecuter.execute(httpRequest, httpUriRequest, useConnectionConfig);
        return resultCallback.on(httpRequest, httpUriRequest, httpResponse, useConnectionConfig, beginDate);
    }

    private static HttpResponse execute(HttpRequest httpRequest, HttpUriRequest httpUriRequest, ConnectionConfig useConnectionConfig) {
        Validate.notNull(httpUriRequest, "httpUriRequest can't be null!", new Object[0]);
        HttpClient httpClient = HttpClientBuilder.build(useConnectionConfig);
        try {
            HttpResponse httpResponse = httpClient.execute(httpUriRequest);
            return httpResponse;
        }
        catch (Exception e) {
            httpUriRequest.abort();
            String message = HttpRequestExecuterExceptionMessageBuilder.build(httpClient, httpRequest, useConnectionConfig, e);
            throw new UncheckedHttpException(message, e);
        }
    }
}

