/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.net.http;

import com.feilong.core.Validate;
import com.feilong.net.http.ConnectionConfig;
import com.feilong.net.http.HttpMethodType;
import com.feilong.net.http.HttpRequest;
import com.feilong.net.http.HttpResponse;
import com.feilong.net.http.builder.HttpRequestExecuter;
import com.feilong.net.http.callback.HttpResponseResultCallback;
import com.feilong.net.http.callback.ResponseBodyAsStringResultCallback;
import com.feilong.net.http.callback.StatusCodeResultCallback;
import java.util.Map;

public final class HttpClientUtil {
    private HttpClientUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static int getResponseStatusCode(String urlString) {
        Validate.notBlank(urlString, "urlString can't be blank!", new Object[0]);
        return HttpClientUtil.getResponseStatusCode(urlString, null);
    }

    public static int getResponseStatusCode(String urlString, ConnectionConfig connectionConfig) {
        Validate.notBlank(urlString, "urlString can't be blank!", new Object[0]);
        HttpRequest httpRequest = new HttpRequest(urlString);
        return HttpClientUtil.getResponseStatusCode(httpRequest, connectionConfig);
    }

    public static int getResponseStatusCode(HttpRequest httpRequest, ConnectionConfig connectionConfig) {
        Validate.notNull(httpRequest, "httpRequest can't be null!", new Object[0]);
        return HttpRequestExecuter.execute(httpRequest, connectionConfig, StatusCodeResultCallback.INSTANCE);
    }

    public static HttpResponse getHttpResponse(String urlString) {
        Validate.notBlank(urlString, "urlString can't be blank!", new Object[0]);
        return HttpClientUtil.getHttpResponse(urlString, null);
    }

    public static HttpResponse getHttpResponse(String urlString, ConnectionConfig connectionConfig) {
        Validate.notBlank(urlString, "urlString can't be blank!", new Object[0]);
        HttpRequest httpRequest = new HttpRequest(urlString);
        return HttpClientUtil.getHttpResponse(httpRequest, connectionConfig);
    }

    public static HttpResponse getHttpResponse(HttpRequest httpRequest, ConnectionConfig connectionConfig) {
        Validate.notNull(httpRequest, "httpRequest can't be null!", new Object[0]);
        return HttpRequestExecuter.execute(httpRequest, connectionConfig, HttpResponseResultCallback.INSTANCE);
    }

    public static String get(String uri) {
        return HttpClientUtil.get(uri, null);
    }

    public static String get(String uri, Map<String, String> requestParamMap) {
        Validate.notBlank(uri, "uri can't be blank!", new Object[0]);
        return HttpClientUtil.getResponseBodyAsString(new HttpRequest(uri, requestParamMap, HttpMethodType.GET));
    }

    public static String put(String uri) {
        return HttpClientUtil.put(uri, null);
    }

    public static String put(String uri, Map<String, String> requestParamMap) {
        Validate.notBlank(uri, "uri can't be blank!", new Object[0]);
        return HttpClientUtil.getResponseBodyAsString(new HttpRequest(uri, requestParamMap, HttpMethodType.PUT));
    }

    public static String post(String uri) {
        return HttpClientUtil.post(uri, (Map<String, String>)null);
    }

    public static String post(String uri, Map<String, String> requestParamMap) {
        Validate.notBlank(uri, "uri can't be blank!", new Object[0]);
        return HttpClientUtil.getResponseBodyAsString(new HttpRequest(uri, requestParamMap, HttpMethodType.POST));
    }

    public static String post(String uri, String requestBody) {
        return HttpClientUtil.post(uri, requestBody, null);
    }

    public static String post(String uri, String requestBody, Map<String, String> headerMap) {
        Validate.notBlank(uri, "uri can't be blank!", new Object[0]);
        HttpRequest httpRequest = new HttpRequest(uri, null, HttpMethodType.POST);
        httpRequest.setHeaderMap(headerMap);
        httpRequest.setRequestBody(requestBody);
        return HttpClientUtil.getResponseBodyAsString(httpRequest);
    }

    public static String getResponseBodyAsString(HttpRequest httpRequest) {
        Validate.notNull(httpRequest, "httpRequest can't be null!", new Object[0]);
        return HttpClientUtil.getResponseBodyAsString(httpRequest, null);
    }

    public static String getResponseBodyAsString(String uri, Map<String, String> requestParamMap, String httpMethod) {
        Validate.notBlank(uri, "uri can't be blank!", new Object[0]);
        return HttpClientUtil.getResponseBodyAsString(new HttpRequest(uri, requestParamMap, httpMethod), null);
    }

    public static String getResponseBodyAsString(String uri, Map<String, String> requestParamMap, HttpMethodType httpMethodType) {
        Validate.notBlank(uri, "uri can't be blank!", new Object[0]);
        return HttpClientUtil.getResponseBodyAsString(new HttpRequest(uri, requestParamMap, httpMethodType), null);
    }

    public static String getResponseBodyAsString(String uri, ConnectionConfig connectionConfig) {
        Validate.notBlank(uri, "uri can't be blank!", new Object[0]);
        return HttpClientUtil.getResponseBodyAsString(new HttpRequest(uri), connectionConfig);
    }

    public static String getResponseBodyAsString(HttpRequest httpRequest, ConnectionConfig connectionConfig) {
        Validate.notNull(httpRequest, "httpRequest can't be null!", new Object[0]);
        return HttpRequestExecuter.execute(httpRequest, connectionConfig, ResponseBodyAsStringResultCallback.INSTANCE);
    }
}

