/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.net.filetransfer.sftp;

import com.feilong.core.Validator;
import com.feilong.core.lang.ObjectUtil;
import com.feilong.json.JsonUtil;
import com.feilong.lib.lang3.StringUtils;
import com.feilong.net.filetransfer.sftp.SFTPFileTransferConfig;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SFTPUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SFTPUtil.class);

    private SFTPUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static Session connectSession(SFTPFileTransferConfig sftpFileTransferConfig) throws JSchException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("will use [sftpFileTransferConfig]:[{}] to create session", (Object)JsonUtil.format(sftpFileTransferConfig));
        }
        JSch jsch = new JSch();
        Session session = jsch.getSession(sftpFileTransferConfig.getUserName(), sftpFileTransferConfig.getHostName(), ObjectUtil.defaultIfNull(sftpFileTransferConfig.getPort(), 22).intValue());
        session.setPassword(sftpFileTransferConfig.getPassword());
        if (Validator.isNotNullOrEmpty(sftpFileTransferConfig.getSshConfig())) {
            session.setConfig(sftpFileTransferConfig.getSshConfig());
        }
        session.setTimeout(sftpFileTransferConfig.getSessionTimeout());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(StringUtils.center("session connecting......", 50, "------"));
        }
        session.connect();
        return session;
    }
}

