/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.json.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsIgnoreUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsIgnoreUtil.class);

    private IsIgnoreUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static boolean isIgnore(Class<?> beanClass, PropertyDescriptor propertyDescriptor, Collection<String> exclusions) {
        String key = propertyDescriptor.getName();
        if (exclusions.contains(key)) {
            return true;
        }
        Method readMethod = null;
        try {
            readMethod = propertyDescriptor.getReadMethod();
        }
        catch (Exception e) {
            LOGGER.info("Property '{}' of {} has no read method. SKIPPED", (Object)key, beanClass);
            return true;
        }
        if (readMethod == null) {
            LOGGER.trace("Property '{}' of {} has no read method. SKIPPED", (Object)key, beanClass);
            return true;
        }
        return false;
    }
}

