/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.json;

import com.feilong.lib.json.JSONArray;
import com.feilong.lib.json.JSONFunction;
import com.feilong.lib.json.JSONObject;
import com.feilong.lib.json.util.JSONUtils;

public class ValueToStringUtil {
    public static String valueToString(Object value) {
        if (value == null || JSONUtils.isNull(value)) {
            return "null";
        }
        if (value instanceof JSONFunction) {
            return ((JSONFunction)value).toString();
        }
        if (value instanceof Number) {
            return JSONUtils.numberToString((Number)value);
        }
        if (value instanceof Boolean || value instanceof JSONObject || value instanceof JSONArray) {
            return value.toString();
        }
        return JSONUtils.quote(value.toString());
    }

    public static String valueToString(Object value, int indentFactor, int indent) {
        if (value == null || JSONUtils.isNull(value)) {
            return "null";
        }
        if (value instanceof JSONFunction) {
            return ((JSONFunction)value).toString();
        }
        if (value instanceof Number) {
            return JSONUtils.numberToString((Number)value);
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof JSONObject) {
            return ((JSONObject)value).toString(indentFactor, indent);
        }
        if (value instanceof JSONArray) {
            return ((JSONArray)value).toString(indentFactor, indent);
        }
        return JSONUtils.quote(value.toString());
    }
}

