/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.json;

import com.feilong.lib.json.ValueToStringUtil;
import com.feilong.lib.json.util.JSONUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class ToStringUtil {
    private ToStringUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static String toString(Map<String, Object> properties, int indentFactor, int indent) {
        StringBuilder sb = new StringBuilder("{");
        Iterator<String> keys = properties.keySet().iterator();
        if (properties.size() == 1) {
            String o = keys.next();
            sb.append(JSONUtils.quote(o.toString()));
            sb.append(": ");
            sb.append(ValueToStringUtil.valueToString(properties.get(o), indentFactor, indent));
        } else {
            int newindent = indent + indentFactor;
            while (keys.hasNext()) {
                String o = keys.next();
                if (sb.length() > 1) {
                    sb.append(",\n");
                } else {
                    sb.append('\n');
                }
                for (int i = 0; i < newindent; ++i) {
                    sb.append(' ');
                }
                sb.append(JSONUtils.quote(o.toString()));
                sb.append(": ");
                sb.append(ValueToStringUtil.valueToString(properties.get(o), indentFactor, newindent));
            }
            if (sb.length() > 1) {
                sb.append('\n');
                for (int i = 0; i < indent; ++i) {
                    sb.append(' ');
                }
            }
            for (int i = 0; i < indent; ++i) {
                sb.insert(0, ' ');
            }
        }
        sb.append('}');
        return sb.toString();
    }

    static String toString(Map<String, Object> properties) {
        StringBuilder sb = new StringBuilder("{");
        Iterator<String> keys = properties.keySet().iterator();
        while (keys.hasNext()) {
            if (sb.length() > 1) {
                sb.append(',');
            }
            String o = keys.next();
            sb.append(JSONUtils.quote(o.toString()));
            sb.append(':');
            sb.append(ValueToStringUtil.valueToString(properties.get(o)));
        }
        sb.append('}');
        return sb.toString();
    }

    static String toString(List elements, int indentFactor, int indent) {
        StringBuilder sb = new StringBuilder("[");
        int len = elements.size();
        if (len == 1) {
            sb.append(ValueToStringUtil.valueToString(elements.get(0), indentFactor, indent));
        } else {
            int i;
            int newindent = indent + indentFactor;
            sb.append('\n');
            for (i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append(",\n");
                }
                for (int j = 0; j < newindent; ++j) {
                    sb.append(' ');
                }
                sb.append(ValueToStringUtil.valueToString(elements.get(i), indentFactor, newindent));
            }
            sb.append('\n');
            for (i = 0; i < indent; ++i) {
                sb.append(' ');
            }
            for (i = 0; i < indent; ++i) {
                sb.insert(0, ' ');
            }
        }
        sb.append(']');
        return sb.toString();
    }

    static String toString(List<Object> elements) {
        StringBuilder sb = new StringBuilder("[");
        int len = elements.size();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(ValueToStringUtil.valueToString(elements.get(i)));
        }
        sb.append(']');
        return sb.toString();
    }
}

