/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.json;

import com.feilong.lib.ezmorph.Morpher;
import com.feilong.lib.ezmorph.MorpherRegistry;
import com.feilong.lib.ezmorph.bean.BeanMorpher;
import com.feilong.lib.ezmorph.object.EnumMorpher;
import com.feilong.lib.ezmorph.object.IdentityObjectMorpher;
import com.feilong.lib.json.util.JSONUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PropertyValueMorpher {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyValueMorpher.class);

    private PropertyValueMorpher() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static Object morphPropertyValue(String key, Object value, Class<?> type, Class<?> targetType) {
        MorpherRegistry morpherRegistry = JSONUtils.getMorpherRegistry();
        Morpher morpher = morpherRegistry.getMorpherFor(targetType);
        if (IdentityObjectMorpher.INSTANCE.equals(morpher)) {
            LOGGER.warn("Can't transform property '{}' from {} into {}.Will register a default Morpher", new Object[]{key, type.getName(), targetType.getName()});
            if (Enum.class.isAssignableFrom(targetType)) {
                morpherRegistry.registerMorpher(new EnumMorpher(targetType));
            } else {
                morpherRegistry.registerMorpher(new BeanMorpher(targetType, morpherRegistry));
            }
        }
        return morpherRegistry.morph(targetType, value);
    }
}

