/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.json;

import com.feilong.lib.json.JSON;
import com.feilong.lib.json.JSONArray;
import com.feilong.lib.json.JSONArrayBuilder;
import com.feilong.lib.json.JSONException;
import com.feilong.lib.json.JSONFunction;
import com.feilong.lib.json.JSONNull;
import com.feilong.lib.json.JSONObject;
import com.feilong.lib.json.JSONObjectBuilder;
import com.feilong.lib.json.JSONSerializer;
import com.feilong.lib.json.JsonConfig;
import com.feilong.lib.json.processors.JsonValueProcessor;
import com.feilong.lib.json.processors.JsonVerifier;
import com.feilong.lib.json.util.JSONTokener;
import com.feilong.lib.json.util.JSONUtils;
import java.lang.annotation.Annotation;

public class ProcessValueUtil {
    private ProcessValueUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static Object processArrayValue(Object value, JsonConfig jsonConfig) {
        JsonValueProcessor jsonValueProcessor;
        if (value != null && (jsonValueProcessor = jsonConfig.findJsonValueProcessor(value.getClass())) != null && !JsonVerifier.isValidJsonValue(value = jsonValueProcessor.processArrayValue(value, jsonConfig))) {
            throw new JSONException("Value is not a valid JSON value. " + value);
        }
        return ProcessValueUtil._processArrayValue(value, jsonConfig);
    }

    private static Object _processArrayValue(Object value, JsonConfig jsonConfig) {
        if (value instanceof JSONTokener) {
            return JSONArrayBuilder._fromJSONTokener((JSONTokener)value, jsonConfig);
        }
        if (value != null && Enum.class.isAssignableFrom(value.getClass())) {
            return ((Enum)value).name();
        }
        if (value instanceof Annotation || value != null && value.getClass().isAnnotation()) {
            throw new JSONException("Unsupported type");
        }
        return ProcessValueUtil.processValue(value, jsonConfig);
    }

    static Object processJsonObjectValue(String key, Object value, JsonConfig jsonConfig) {
        JsonValueProcessor processor;
        if (value != null && (processor = jsonConfig.findJsonValueProcessor(value.getClass(), key)) != null && !JsonVerifier.isValidJsonValue(value = processor.processObjectValue(null, value, jsonConfig))) {
            throw new JSONException("Value is not a valid JSON value. " + value);
        }
        return ProcessValueUtil._processJSONObjectValue(value, jsonConfig);
    }

    private static Object _processJSONObjectValue(Object value, JsonConfig jsonConfig) {
        if (value instanceof JSONTokener) {
            return JSONObjectBuilder._fromJSONTokener((JSONTokener)value, jsonConfig);
        }
        if (value != null && Enum.class.isAssignableFrom(value.getClass())) {
            return ((Enum)value).name();
        }
        return ProcessValueUtil.processValue(value, jsonConfig);
    }

    static Object processValue(Object value, JsonConfig jsonConfig) {
        if (JSONNull.getInstance().equals(value)) {
            return JSONNull.getInstance();
        }
        if (Class.class.isAssignableFrom(value.getClass()) || value instanceof Class) {
            return ((Class)value).getName();
        }
        if (JSONUtils.isFunction(value)) {
            if (value instanceof String) {
                value = JSONFunction.parse((String)value);
            }
            return value;
        }
        if (value instanceof JSON) {
            return JSONSerializer.toJSON(value, jsonConfig);
        }
        if (JSONUtils.isArray(value)) {
            return JSONArray.fromObject(value, jsonConfig);
        }
        if (JSONUtils.isString(value)) {
            String str = String.valueOf(value);
            if (JSONUtils.hasQuotes(str)) {
                String stripped = JSONUtils.stripQuotes(str);
                if (JSONUtils.isFunction(stripped)) {
                    return "\"" + stripped + "\"";
                }
                if (stripped.startsWith("[") && stripped.endsWith("]")) {
                    return stripped;
                }
                if (stripped.startsWith("{") && stripped.endsWith("}")) {
                    return stripped;
                }
                return str;
            }
            if (JSONUtils.isJsonKeyword(str)) {
                return str;
            }
            if (JSONUtils.mayBeJSON(str)) {
                try {
                    return JSONSerializer.toJSON((Object)str, jsonConfig);
                }
                catch (JSONException jsone) {
                    return str;
                }
            }
            return str;
        }
        if (JSONUtils.isNumber(value)) {
            JSONUtils.testValidity(value);
            return JSONUtils.transformNumber((Number)value);
        }
        if (JSONUtils.isBoolean(value)) {
            return value;
        }
        JSONObject jsonObject = JSONObjectBuilder.build(value, jsonConfig);
        if (jsonObject.isNullObject()) {
            return JSONNull.getInstance();
        }
        return jsonObject;
    }
}

