/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.json;

import com.feilong.lib.json.JSON;
import com.feilong.lib.json.JSONArray;
import com.feilong.lib.json.JSONArrayToBeanUtil;
import com.feilong.lib.json.JSONException;
import com.feilong.lib.json.JSONNull;
import com.feilong.lib.json.JSONObject;
import com.feilong.lib.json.JsonConfig;
import com.feilong.lib.json.util.JSONTokener;
import com.feilong.lib.json.util.JSONUtils;

public class JSONSerializer {
    private JSONSerializer() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static Object toJava(JSON json) {
        return JSONSerializer.toJava(json, new JsonConfig());
    }

    private static Object toJava(JSON json, JsonConfig jsonConfig) {
        if (JSONUtils.isNull(json)) {
            return null;
        }
        if (json instanceof JSONArray) {
            if (jsonConfig.getArrayMode() == 2) {
                return JSONArrayToBeanUtil.toArray((JSONArray)json, jsonConfig);
            }
            return JSONArrayToBeanUtil.toCollection((JSONArray)json, jsonConfig);
        }
        return JSONObject.toBean((JSONObject)json, jsonConfig);
    }

    public static JSON toJSON(Object object) {
        return JSONSerializer.toJSON(object, new JsonConfig());
    }

    public static JSON toJSON(Object object, JsonConfig jsonConfig) {
        if (object == null) {
            return JSONNull.getInstance();
        }
        if (object instanceof String) {
            return JSONSerializer.toJSON((String)object, jsonConfig);
        }
        if (JSONUtils.isArray(object)) {
            return JSONArray.fromObject(object, jsonConfig);
        }
        try {
            return JSONObject.fromObject(object, jsonConfig);
        }
        catch (JSONException e) {
            if (object instanceof JSONTokener) {
                ((JSONTokener)object).reset();
            }
            return JSONArray.fromObject(object, jsonConfig);
        }
    }

    private static JSON toJSON(String string, JsonConfig jsonConfig) {
        if (string.startsWith("[")) {
            return JSONArray.fromObject(string, jsonConfig);
        }
        if (string.startsWith("{")) {
            return JSONObject.fromObject(string, jsonConfig);
        }
        if ("null".equals(string)) {
            return JSONNull.getInstance();
        }
        throw new JSONException("Invalid JSON String");
    }
}

