/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.json;

import com.feilong.lib.json.JSON;
import com.feilong.lib.json.JSONArray;
import com.feilong.lib.json.JSONException;
import com.feilong.lib.json.JSONFunction;
import com.feilong.lib.json.JSONNull;
import com.feilong.lib.json.JSONObject;
import com.feilong.lib.json.JsonConfig;
import com.feilong.lib.json.util.CycleSetUtil;
import com.feilong.lib.json.util.JSONExceptionUtil;
import com.feilong.lib.json.util.JSONTokener;
import com.feilong.lib.json.util.JSONUtils;
import com.feilong.lib.lang3.StringUtils;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Iterator;

public class JSONArrayBuilder {
    private JSONArrayBuilder() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static JSONArray fromObject(Object object, JsonConfig jsonConfig) {
        if (object instanceof JSONArray) {
            return JSONArrayBuilder._fromJSONArray((JSONArray)object, jsonConfig);
        }
        if (object instanceof Collection) {
            return JSONArrayBuilder._fromCollection((Collection)object, jsonConfig);
        }
        if (object instanceof JSONTokener) {
            return JSONArrayBuilder._fromJSONTokener((JSONTokener)object, jsonConfig);
        }
        if (object instanceof String) {
            return JSONArrayBuilder._fromString((String)object, jsonConfig);
        }
        if (object != null && object.getClass().isArray()) {
            Class<?> type = object.getClass().getComponentType();
            if (!type.isPrimitive()) {
                return JSONArrayBuilder._fromArray((Object[])object, jsonConfig);
            }
            if (type == Boolean.TYPE) {
                return JSONArrayBuilder._fromArray((boolean[])object, jsonConfig);
            }
            if (type == Byte.TYPE) {
                return JSONArrayBuilder._fromArray((byte[])object, jsonConfig);
            }
            if (type == Short.TYPE) {
                return JSONArrayBuilder._fromArray((short[])object, jsonConfig);
            }
            if (type == Integer.TYPE) {
                return JSONArrayBuilder._fromArray((int[])object, jsonConfig);
            }
            if (type == Long.TYPE) {
                return JSONArrayBuilder._fromArray((long[])object, jsonConfig);
            }
            if (type == Float.TYPE) {
                return JSONArrayBuilder._fromArray((float[])object, jsonConfig);
            }
            if (type == Double.TYPE) {
                return JSONArrayBuilder._fromArray((double[])object, jsonConfig);
            }
            if (type == Character.TYPE) {
                return JSONArrayBuilder._fromArray((char[])object, jsonConfig);
            }
            throw new JSONException("Unsupported type");
        }
        if (JSONUtils.isBoolean(object) || JSONUtils.isFunction(object) || JSONUtils.isNumber(object) || JSONUtils.isNull(object) || JSONUtils.isString(object) || object instanceof JSON) {
            JSONArray jsonArray = new JSONArray().element(object, jsonConfig);
            return jsonArray;
        }
        if (object instanceof Enum) {
            return JSONArrayBuilder._fromArray((Enum)object, jsonConfig);
        }
        if (object instanceof Annotation || object != null && object.getClass().isAnnotation()) {
            throw new JSONException("Unsupported type");
        }
        if (JSONUtils.isObject(object)) {
            JSONArray jsonArray = new JSONArray().element(JSONObject.fromObject(object, jsonConfig));
            return jsonArray;
        }
        throw new JSONException("Unsupported type");
    }

    private static JSONArray _fromArray(boolean[] array, JsonConfig jsonConfig) {
        if (!CycleSetUtil.addInstance(array)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(array);
            }
            catch (Exception e) {
                CycleSetUtil.removeInstance(array);
                throw JSONExceptionUtil.build("", e);
            }
        }
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < array.length; ++i) {
            jsonArray.addValue(array[i], jsonConfig);
        }
        CycleSetUtil.removeInstance(array);
        return jsonArray;
    }

    private static JSONArray _fromArray(byte[] array, JsonConfig jsonConfig) {
        if (!CycleSetUtil.addInstance(array)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(array);
            }
            catch (Exception e) {
                CycleSetUtil.removeInstance(array);
                throw JSONExceptionUtil.build("", e);
            }
        }
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < array.length; ++i) {
            Number n = JSONUtils.transformNumber(array[i]);
            jsonArray.addValue(n, jsonConfig);
        }
        CycleSetUtil.removeInstance(array);
        return jsonArray;
    }

    private static JSONArray _fromArray(char[] array, JsonConfig jsonConfig) {
        if (!CycleSetUtil.addInstance(array)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(array);
            }
            catch (Exception e) {
                CycleSetUtil.removeInstance(array);
                throw JSONExceptionUtil.build("", e);
            }
        }
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < array.length; ++i) {
            jsonArray.addValue(Character.valueOf(array[i]), jsonConfig);
        }
        CycleSetUtil.removeInstance(array);
        return jsonArray;
    }

    private static JSONArray _fromArray(double[] array, JsonConfig jsonConfig) {
        if (!CycleSetUtil.addInstance(array)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(array);
            }
            catch (Exception e) {
                CycleSetUtil.removeInstance(array);
                throw JSONExceptionUtil.build("", e);
            }
        }
        JSONArray jsonArray = new JSONArray();
        try {
            for (int i = 0; i < array.length; ++i) {
                Double d = array[i];
                JSONUtils.testValidity(d);
                jsonArray.addValue(d, jsonConfig);
            }
        }
        catch (Exception e) {
            CycleSetUtil.removeInstance(array);
            throw JSONExceptionUtil.build("", e);
        }
        CycleSetUtil.removeInstance(array);
        return jsonArray;
    }

    private static JSONArray _fromArray(Enum e, JsonConfig jsonConfig) {
        if (!CycleSetUtil.addInstance(e)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(e);
            }
            catch (Exception ex) {
                CycleSetUtil.removeInstance(e);
                throw JSONExceptionUtil.build("", ex);
            }
        }
        JSONArray jsonArray = new JSONArray();
        if (e == null) {
            JSONException jsone = new JSONException("enum value is null");
            CycleSetUtil.removeInstance(e);
            throw jsone;
        }
        jsonArray.addValue(e, jsonConfig);
        CycleSetUtil.removeInstance(e);
        return jsonArray;
    }

    private static JSONArray _fromArray(float[] array, JsonConfig jsonConfig) {
        if (!CycleSetUtil.addInstance(array)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(array);
            }
            catch (Exception e) {
                CycleSetUtil.removeInstance(array);
                throw JSONExceptionUtil.build("", e);
            }
        }
        JSONArray jsonArray = new JSONArray();
        try {
            for (int i = 0; i < array.length; ++i) {
                float f = array[i];
                JSONUtils.testValidity(Float.valueOf(f));
                jsonArray.addValue(Float.valueOf(f), jsonConfig);
            }
        }
        catch (Exception e) {
            CycleSetUtil.removeInstance(array);
            throw JSONExceptionUtil.build("", e);
        }
        CycleSetUtil.removeInstance(array);
        return jsonArray;
    }

    private static JSONArray _fromArray(int[] array, JsonConfig jsonConfig) {
        if (!CycleSetUtil.addInstance(array)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(array);
            }
            catch (Exception e) {
                CycleSetUtil.removeInstance(array);
                throw JSONExceptionUtil.build("", e);
            }
        }
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < array.length; ++i) {
            Integer n = array[i];
            jsonArray.addValue(n, jsonConfig);
        }
        CycleSetUtil.removeInstance(array);
        return jsonArray;
    }

    private static JSONArray _fromArray(long[] array, JsonConfig jsonConfig) {
        if (!CycleSetUtil.addInstance(array)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(array);
            }
            catch (Exception e) {
                CycleSetUtil.removeInstance(array);
                throw JSONExceptionUtil.build("", e);
            }
        }
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < array.length; ++i) {
            Number n = JSONUtils.transformNumber(array[i]);
            jsonArray.addValue(n, jsonConfig);
        }
        CycleSetUtil.removeInstance(array);
        return jsonArray;
    }

    private static JSONArray _fromArray(Object[] array, JsonConfig jsonConfig) {
        if (!CycleSetUtil.addInstance(array)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(array);
            }
            catch (Exception e) {
                CycleSetUtil.removeInstance(array);
                throw JSONExceptionUtil.build("", e);
            }
        }
        JSONArray jsonArray = new JSONArray();
        try {
            for (int i = 0; i < array.length; ++i) {
                Object element = array[i];
                jsonArray.addValue(element, jsonConfig);
            }
        }
        catch (Exception e) {
            CycleSetUtil.removeInstance(array);
            throw JSONExceptionUtil.build("", e);
        }
        CycleSetUtil.removeInstance(array);
        return jsonArray;
    }

    private static JSONArray _fromArray(short[] array, JsonConfig jsonConfig) {
        if (!CycleSetUtil.addInstance(array)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(array);
            }
            catch (Exception e) {
                CycleSetUtil.removeInstance(array);
                throw JSONExceptionUtil.build("", e);
            }
        }
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < array.length; ++i) {
            Number n = JSONUtils.transformNumber(array[i]);
            jsonArray.addValue(n, jsonConfig);
        }
        CycleSetUtil.removeInstance(array);
        return jsonArray;
    }

    static JSONArray _fromCollection(Collection collection, JsonConfig jsonConfig) {
        if (!CycleSetUtil.addInstance(collection)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(collection);
            }
            catch (Exception e) {
                CycleSetUtil.removeInstance(collection);
                throw JSONExceptionUtil.build("", e);
            }
        }
        JSONArray jsonArray = new JSONArray();
        try {
            for (Object element : collection) {
                jsonArray.addValue(element, jsonConfig);
            }
        }
        catch (Exception e) {
            CycleSetUtil.removeInstance(collection);
            throw JSONExceptionUtil.build("", e);
        }
        CycleSetUtil.removeInstance(collection);
        return jsonArray;
    }

    private static JSONArray _fromJSONArray(JSONArray array, JsonConfig jsonConfig) {
        if (!CycleSetUtil.addInstance(array)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(array);
            }
            catch (Exception e) {
                CycleSetUtil.removeInstance(array);
                throw JSONExceptionUtil.build("", e);
            }
        }
        JSONArray jsonArray = new JSONArray();
        Iterator elements = array.iterator();
        while (elements.hasNext()) {
            Object element = elements.next();
            jsonArray.addValue(element, jsonConfig);
        }
        CycleSetUtil.removeInstance(array);
        return jsonArray;
    }

    static JSONArray _fromJSONTokener(JSONTokener tokener, JsonConfig jsonConfig) {
        JSONArray jsonArray = new JSONArray();
        try {
            if (tokener.nextClean() != '[') {
                throw tokener.syntaxError("A JSONArray text must start with '['");
            }
            if (tokener.nextClean() == ']') {
                return jsonArray;
            }
            tokener.back();
            block6: while (true) {
                if (tokener.nextClean() == ',') {
                    tokener.back();
                    jsonArray.elements.add(JSONNull.getInstance());
                } else {
                    tokener.back();
                    Object v = tokener.nextValue(jsonConfig);
                    if (!JSONUtils.isFunctionHeader(v)) {
                        if (v instanceof String && JSONUtils.mayBeJSON((String)v)) {
                            jsonArray.addValue("\"" + v + "\"", jsonConfig);
                        } else {
                            jsonArray.addValue(v, jsonConfig);
                        }
                    } else {
                        char ch;
                        String params = JSONUtils.getFunctionParams((String)v);
                        int i = 0;
                        StringBuffer sb = new StringBuffer();
                        while ((ch = tokener.next()) != '\u0000') {
                            if (ch == '{') {
                                ++i;
                            }
                            if (ch == '}') {
                                --i;
                            }
                            sb.append(ch);
                            if (i != 0) continue;
                            break;
                        }
                        if (i != 0) {
                            throw tokener.syntaxError("Unbalanced '{' or '}' on prop: " + v);
                        }
                        String text = sb.toString();
                        text = text.substring(1, text.length() - 1).trim();
                        jsonArray.addValue(new JSONFunction(params != null ? StringUtils.split(params, ",") : null, text), jsonConfig);
                    }
                }
                switch (tokener.nextClean()) {
                    case ',': 
                    case ';': {
                        if (tokener.nextClean() == ']') {
                            return jsonArray;
                        }
                        tokener.back();
                        continue block6;
                    }
                    case ']': {
                        return jsonArray;
                    }
                }
                break;
            }
            throw tokener.syntaxError("Expected a ',' or ']'");
        }
        catch (Exception e) {
            throw JSONExceptionUtil.build("", e);
        }
    }

    private static JSONArray _fromString(String string, JsonConfig jsonConfig) {
        return JSONArrayBuilder._fromJSONTokener(new JSONTokener(string), jsonConfig);
    }
}

