/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.json;

import com.feilong.core.bean.PropertyUtil;
import com.feilong.lib.beanutils.PropertyUtils;
import com.feilong.lib.json.JSONException;
import com.feilong.lib.json.JSONObject;
import com.feilong.lib.json.JSONObjectSetValueCore;
import com.feilong.lib.json.JsonConfig;
import com.feilong.lib.json.processors.JsonValueProcessor;
import com.feilong.lib.json.processors.JsonVerifier;
import com.feilong.lib.json.processors.PropertyNameProcessor;
import com.feilong.lib.json.util.CycleSetUtil;
import com.feilong.lib.json.util.IsIgnoreUtil;
import com.feilong.lib.json.util.JSONExceptionUtil;
import com.feilong.lib.json.util.KeyUpdate;
import com.feilong.lib.json.util.PropertyFilter;
import java.beans.PropertyDescriptor;
import java.util.Collection;

public class BeanProcessing {
    private BeanProcessing() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static JSONObject defaultBeanProcessing(Object bean, JsonConfig jsonConfig) {
        Class<?> beanClass = bean.getClass();
        PropertyNameProcessor propertyNameProcessor = jsonConfig.findJsonPropertyNameProcessor(beanClass);
        Collection<String> exclusions = jsonConfig.getMergedExcludes();
        PropertyFilter jsonPropertyFilter = jsonConfig.getJsonPropertyFilter();
        JSONObject jsonObject = new JSONObject();
        try {
            PropertyDescriptor[] propertyDescriptors = PropertyUtil.getPropertyDescriptors(beanClass);
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
                if (IsIgnoreUtil.isIgnore(beanClass, propertyDescriptor, exclusions)) continue;
                String key = propertyDescriptor.getName();
                Object value = PropertyUtils.getSimpleProperty(bean, key);
                if (jsonPropertyFilter != null && jsonPropertyFilter.apply(bean, key, value)) continue;
                Class<?> type = propertyDescriptor.getPropertyType();
                BeanProcessing.set(jsonObject, beanClass, key, value, type, jsonConfig, propertyNameProcessor);
            }
        }
        catch (Exception e) {
            CycleSetUtil.removeInstance(bean);
            throw JSONExceptionUtil.build("", e);
        }
        return jsonObject;
    }

    private static void set(JSONObject jsonObject, Class<?> beanClass, String key, Object value, Class<?> type, JsonConfig jsonConfig, PropertyNameProcessor propertyNameProcessor) {
        JsonValueProcessor jsonValueProcessor = jsonConfig.findJsonValueProcessor(beanClass, type, key);
        boolean bypass = false;
        if (jsonValueProcessor != null) {
            value = jsonValueProcessor.processObjectValue(key, value, jsonConfig);
            bypass = true;
            if (!JsonVerifier.isValidJsonValue(value)) {
                throw new JSONException("Value is not a valid JSON value. " + value);
            }
        }
        key = KeyUpdate.update(beanClass, key, propertyNameProcessor);
        JSONObjectSetValueCore.setValue(jsonObject, key, value, type, jsonConfig, bypass);
    }
}

