/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.ezmorph.object;

import com.feilong.lib.ezmorph.MorphException;
import com.feilong.lib.ezmorph.object.AbstractObjectMorpher;
import com.feilong.lib.ezmorph.object.BigDecimalMorpher;
import com.feilong.lib.ezmorph.object.BigIntegerMorpher;
import com.feilong.lib.ezmorph.primitive.ByteMorpher;
import com.feilong.lib.ezmorph.primitive.DoubleMorpher;
import com.feilong.lib.ezmorph.primitive.FloatMorpher;
import com.feilong.lib.ezmorph.primitive.IntMorpher;
import com.feilong.lib.ezmorph.primitive.LongMorpher;
import com.feilong.lib.ezmorph.primitive.ShortMorpher;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class NumberMorpher
extends AbstractObjectMorpher<Number> {
    private final Class<?> type;

    public NumberMorpher(Class<?> type) {
        super(false);
        if (type == null) {
            throw new MorphException("Must specify a type");
        }
        if (!(type == Byte.TYPE || type == Short.TYPE || type == Integer.TYPE || type == Long.TYPE || type == Float.TYPE || type == Double.TYPE || Byte.class.isAssignableFrom(type) || Short.class.isAssignableFrom(type) || Integer.class.isAssignableFrom(type) || Long.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type) || Double.class.isAssignableFrom(type) || BigInteger.class.isAssignableFrom(type) || BigDecimal.class.isAssignableFrom(type))) {
            throw new MorphException("Must specify a Number subclass");
        }
        this.type = type;
    }

    public NumberMorpher(Class<?> type, Number defaultValue) {
        super(true);
        if (type == null) {
            throw new MorphException("Must specify a type");
        }
        if (!(type == Byte.TYPE || type == Short.TYPE || type == Integer.TYPE || type == Long.TYPE || type == Float.TYPE || type == Double.TYPE || Byte.class.isAssignableFrom(type) || Short.class.isAssignableFrom(type) || Integer.class.isAssignableFrom(type) || Long.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type) || Double.class.isAssignableFrom(type) || BigInteger.class.isAssignableFrom(type) || BigDecimal.class.isAssignableFrom(type))) {
            throw new MorphException("Must specify a Number subclass");
        }
        if (defaultValue != null && !type.isInstance(defaultValue)) {
            throw new MorphException("Default value must be of type " + type);
        }
        this.type = type;
        this.setDefaultValue(defaultValue);
    }

    @Override
    public Object morph(Object value) {
        if (value != null && this.type.isAssignableFrom(value.getClass())) {
            return value;
        }
        String str = String.valueOf(value).trim();
        if (!this.type.isPrimitive() && (value == null || str.length() == 0 || "null".equalsIgnoreCase(str))) {
            return null;
        }
        if (NumberMorpher.isDecimalNumber(this.type)) {
            if (Float.class.isAssignableFrom(this.type) || Float.TYPE == this.type) {
                return this.morphToFloat(str);
            }
            if (Double.class.isAssignableFrom(this.type) || Double.TYPE == this.type) {
                return this.morphToDouble(str);
            }
            return this.morphToBigDecimal(str);
        }
        if (Byte.class.isAssignableFrom(this.type) || Byte.TYPE == this.type) {
            return this.morphToByte(str);
        }
        if (Short.class.isAssignableFrom(this.type) || Short.TYPE == this.type) {
            return this.morphToShort(str);
        }
        if (Integer.class.isAssignableFrom(this.type) || Integer.TYPE == this.type) {
            return this.morphToInteger(str);
        }
        if (Long.class.isAssignableFrom(this.type) || Long.TYPE == this.type) {
            return this.morphToLong(str);
        }
        return this.morphToBigInteger(str);
    }

    @Override
    public Class<?> morphsTo() {
        return this.type;
    }

    public void setDefaultValue(Number defaultValue) {
        if (defaultValue != null && !this.type.isInstance(defaultValue)) {
            throw new MorphException("Default value must be of type " + this.type);
        }
        this.defaultValue = defaultValue;
    }

    private static boolean isDecimalNumber(Class<?> type) {
        return Double.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type) || Double.TYPE == type || Float.TYPE == type || BigDecimal.class.isAssignableFrom(type);
    }

    private Object morphToBigDecimal(String str) {
        if (this.isUseDefault()) {
            return new BigDecimalMorpher((BigDecimal)this.defaultValue).morph(str);
        }
        return new BigDecimal(str);
    }

    private Object morphToBigInteger(String str) {
        if (this.isUseDefault()) {
            return new BigIntegerMorpher((BigInteger)this.defaultValue).morph(str);
        }
        return new BigInteger(str);
    }

    private Object morphToByte(String str) {
        if (this.isUseDefault()) {
            if (this.defaultValue == null) {
                return null;
            }
            return new ByteMorpher(((Number)this.defaultValue).byteValue()).morph(str);
        }
        return new ByteMorpher().morph(str);
    }

    private Object morphToDouble(String str) {
        if (this.isUseDefault()) {
            if (this.defaultValue == null) {
                return null;
            }
            return new DoubleMorpher(((Number)this.defaultValue).doubleValue()).morph(str);
        }
        return new DoubleMorpher().morph(str);
    }

    private Object morphToFloat(String str) {
        if (this.isUseDefault()) {
            if (this.defaultValue == null) {
                return null;
            }
            return Float.valueOf(new FloatMorpher(((Number)this.defaultValue).floatValue()).morph(str));
        }
        return Float.valueOf(new FloatMorpher().morph(str));
    }

    private Object morphToInteger(String str) {
        if (this.isUseDefault()) {
            if (this.defaultValue == null) {
                return null;
            }
            return new IntMorpher(((Number)this.defaultValue).intValue()).morph(str);
        }
        return new IntMorpher().morph(str);
    }

    private Object morphToLong(String str) {
        if (this.isUseDefault()) {
            if (this.defaultValue == null) {
                return null;
            }
            return new LongMorpher(((Number)this.defaultValue).longValue()).morph(str);
        }
        return new LongMorpher().morph(str);
    }

    private Object morphToShort(String str) {
        if (this.isUseDefault()) {
            if (this.defaultValue == null) {
                return null;
            }
            return new ShortMorpher(((Number)this.defaultValue).shortValue()).morph(str);
        }
        return new ShortMorpher().morph(str);
    }
}

