/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.ezmorph.object;

import com.feilong.lib.ezmorph.MorphException;
import com.feilong.lib.ezmorph.object.AbstractObjectMorpher;

public final class BooleanObjectMorpher
extends AbstractObjectMorpher<Boolean> {
    public BooleanObjectMorpher() {
    }

    public BooleanObjectMorpher(Boolean defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    @Override
    public Object morph(Object value) {
        if (value == null) {
            if (this.isUseDefault()) {
                return this.defaultValue;
            }
            throw new MorphException("value is null");
        }
        if (value instanceof Boolean) {
            return value;
        }
        String s = String.valueOf(value);
        if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("on")) {
            return Boolean.TRUE;
        }
        if (s.equalsIgnoreCase("false") || s.equalsIgnoreCase("no") || s.equalsIgnoreCase("off")) {
            return Boolean.FALSE;
        }
        if (this.isUseDefault()) {
            return this.defaultValue;
        }
        throw new MorphException("Can't morph value: " + value);
    }

    @Override
    public Class<?> morphsTo() {
        return Boolean.class;
    }
}

