/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.ezmorph.array;

import com.feilong.lib.ezmorph.MorphException;
import com.feilong.lib.ezmorph.array.AbstractArrayMorpher;
import com.feilong.lib.ezmorph.primitive.ShortMorpher;
import java.lang.reflect.Array;

public final class ShortArrayMorpher
extends AbstractArrayMorpher {
    private static final Class<?> SHORT_ARRAY_CLASS = short[].class;
    private short defaultValue;

    public ShortArrayMorpher() {
        super(false);
    }

    public ShortArrayMorpher(short defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public short getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Object morph(Object array) {
        if (array == null) {
            return null;
        }
        if (SHORT_ARRAY_CLASS.isAssignableFrom(array.getClass())) {
            return array;
        }
        if (array.getClass().isArray()) {
            ShortMorpher morpher;
            int length = Array.getLength(array);
            int dims = this.getDimensions(array.getClass());
            int[] dimensions = ShortArrayMorpher.createDimensions(dims, length);
            Object result = Array.newInstance(Short.TYPE, dimensions);
            ShortMorpher shortMorpher = morpher = this.isUseDefault() ? new ShortMorpher(this.defaultValue) : new ShortMorpher();
            if (dims == 1) {
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, morpher.morph(Array.get(array, index)));
                }
            } else {
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, this.morph(Array.get(array, index)));
                }
            }
            return result;
        }
        throw new MorphException("argument is not an array: " + array.getClass());
    }

    @Override
    public Class<?> morphsTo() {
        return SHORT_ARRAY_CLASS;
    }
}

