/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.ezmorph.array;

import com.feilong.lib.ezmorph.MorphException;
import com.feilong.lib.ezmorph.Morpher;
import com.feilong.lib.ezmorph.array.AbstractArrayMorpher;
import java.lang.reflect.Array;
import java.lang.reflect.Method;

public final class ObjectArrayMorpher
extends AbstractArrayMorpher {
    private Morpher morpher;
    private Method morphMethod;
    private Class<?> target;
    private Class<?> targetArrayClass;

    public ObjectArrayMorpher(Morpher morpher) {
        super(false);
        this.setMorpher(morpher);
    }

    @Override
    public Object morph(Object array) {
        if (array == null) {
            return null;
        }
        if (array.getClass().isArray()) {
            int length = Array.getLength(array);
            int dims = this.getDimensions(array.getClass());
            int[] dimensions = ObjectArrayMorpher.createDimensions(dims, length);
            Object result = Array.newInstance(this.target, dimensions);
            if (dims == 1) {
                for (int index = 0; index < length; ++index) {
                    try {
                        Object value = Array.get(array, index);
                        if (value != null && !this.morpher.supports(value.getClass())) {
                            throw new MorphException(value.getClass() + " is not supported");
                        }
                        Object morphed = this.morphMethod.invoke((Object)this.morpher, value);
                        Array.set(result, index, morphed);
                        continue;
                    }
                    catch (MorphException me) {
                        throw me;
                    }
                    catch (Exception e) {
                        throw new MorphException(e);
                    }
                }
            } else {
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, this.morph(Array.get(array, index)));
                }
            }
            return result;
        }
        throw new MorphException("argument is not an array: " + array.getClass());
    }

    @Override
    public Class<?> morphsTo() {
        return this.targetArrayClass;
    }

    @Override
    public boolean supports(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (!clazz.isArray()) {
            return false;
        }
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return this.morpher.supports(clazz);
    }

    private void setMorpher(Morpher morpher) {
        if (morpher == null) {
            throw new IllegalArgumentException("morpher can not be null");
        }
        if (morpher.morphsTo().isArray()) {
            throw new IllegalArgumentException("morpher target class can not be an array");
        }
        this.morpher = morpher;
        this.targetArrayClass = Array.newInstance(morpher.morphsTo(), 1).getClass();
        this.target = morpher.morphsTo();
        try {
            this.morphMethod = morpher.getClass().getDeclaredMethod("morph", Object.class);
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException(nsme.getMessage());
        }
    }
}

