/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.ezmorph.array;

import com.feilong.lib.ezmorph.MorphException;
import com.feilong.lib.ezmorph.array.AbstractArrayMorpher;
import com.feilong.lib.ezmorph.primitive.FloatMorpher;
import java.lang.reflect.Array;

public final class FloatArrayMorpher
extends AbstractArrayMorpher {
    private static final Class<?> FLOAT_ARRAY_CLASS = float[].class;
    private float defaultValue;

    public FloatArrayMorpher() {
        super(false);
    }

    public FloatArrayMorpher(float defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public float getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Object morph(Object array) {
        if (array == null) {
            return null;
        }
        if (FLOAT_ARRAY_CLASS.isAssignableFrom(array.getClass())) {
            return array;
        }
        if (array.getClass().isArray()) {
            FloatMorpher morpher;
            int length = Array.getLength(array);
            int dims = this.getDimensions(array.getClass());
            int[] dimensions = FloatArrayMorpher.createDimensions(dims, length);
            Object result = Array.newInstance(Float.TYPE, dimensions);
            FloatMorpher floatMorpher = morpher = this.isUseDefault() ? new FloatMorpher(this.defaultValue) : new FloatMorpher();
            if (dims == 1) {
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, Float.valueOf(morpher.morph(Array.get(array, index))));
                }
            } else {
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, this.morph(Array.get(array, index)));
                }
            }
            return result;
        }
        throw new MorphException("argument is not an array: " + array.getClass());
    }

    @Override
    public Class<?> morphsTo() {
        return FLOAT_ARRAY_CLASS;
    }
}

