/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.ezmorph.array;

import com.feilong.lib.ezmorph.MorphException;
import com.feilong.lib.ezmorph.array.AbstractArrayMorpher;
import com.feilong.lib.ezmorph.primitive.BooleanMorpher;
import java.lang.reflect.Array;

public final class BooleanObjectArrayMorpher
extends AbstractArrayMorpher {
    private static final Class<?> BOOLEAN_OBJECT_ARRAY_CLASS = Boolean[].class;
    private Boolean defaultValue;

    public BooleanObjectArrayMorpher() {
        super(false);
    }

    public BooleanObjectArrayMorpher(Boolean defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public Boolean getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Object morph(Object array) {
        if (array == null) {
            return null;
        }
        if (BOOLEAN_OBJECT_ARRAY_CLASS.isAssignableFrom(array.getClass())) {
            return array;
        }
        if (array.getClass().isArray()) {
            int length = Array.getLength(array);
            int dims = this.getDimensions(array.getClass());
            int[] dimensions = BooleanObjectArrayMorpher.createDimensions(dims, length);
            Object result = Array.newInstance(Boolean.class, dimensions);
            if (dims == 1) {
                BooleanMorpher morpher = null;
                if (this.isUseDefault()) {
                    if (this.defaultValue == null) {
                        for (int index = 0; index < length; ++index) {
                            Array.set(result, index, null);
                        }
                        return result;
                    }
                    morpher = new BooleanMorpher(this.defaultValue);
                } else {
                    morpher = new BooleanMorpher();
                }
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, morpher.morph(Array.get(array, index)) ? Boolean.TRUE : Boolean.FALSE);
                }
            } else {
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, this.morph(Array.get(array, index)));
                }
            }
            return result;
        }
        throw new MorphException("argument is not an array: " + array.getClass());
    }

    @Override
    public Class<?> morphsTo() {
        return BOOLEAN_OBJECT_ARRAY_CLASS;
    }
}

