/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.excel.convertor;

import com.feilong.core.bean.ConvertUtil;
import com.feilong.excel.ExcelException;
import com.feilong.excel.definition.ExcelCell;
import com.feilong.lib.excel.convertor.AbstractChoiceConvertor;

public class IntegerConvertor
extends AbstractChoiceConvertor<Integer> {
    @Override
    protected Integer convertValue(int sheetNo, String cellIndex, ExcelCell excelCell, Object value) {
        if (value instanceof String) {
            String str = (String)value;
            if ((str = str.trim()).length() == 0) {
                if (!excelCell.isMandatory()) {
                    return null;
                }
                throw new ExcelException(1, sheetNo, cellIndex, null, excelCell);
            }
            try {
                return ConvertUtil.toInteger(value);
            }
            catch (Exception e) {
                throw new ExcelException(11, sheetNo, cellIndex, value, excelCell);
            }
        }
        if (value instanceof Double) {
            return (int)Math.rint((Double)value);
        }
        throw new ExcelException(11, sheetNo, cellIndex, value, excelCell);
    }

    @Override
    public String getDataTypeAbbr() {
        return "integer";
    }

    @Override
    public Class<Integer> supportClass() {
        return Integer.class;
    }
}

