/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.collection4;

import com.feilong.lib.collection4.CollectionUtils;
import com.feilong.lib.collection4.IteratorUtils;
import com.feilong.lib.collection4.functors.EqualPredicate;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.Closure;
import org.apache.commons.collections4.Equator;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.Transformer;

public class IterableUtils {
    public static <E> void forEach(Iterable<E> iterable, Closure<? super E> closure) {
        IteratorUtils.forEach(IterableUtils.emptyIteratorIfNull(iterable), closure);
    }

    public static <E> E forEachButLast(Iterable<E> iterable, Closure<? super E> closure) {
        return IteratorUtils.forEachButLast(IterableUtils.emptyIteratorIfNull(iterable), closure);
    }

    public static <E> E find(Iterable<E> iterable, Predicate<? super E> predicate) {
        return IteratorUtils.find(IterableUtils.emptyIteratorIfNull(iterable), predicate);
    }

    public static <E> int indexOf(Iterable<E> iterable, Predicate<? super E> predicate) {
        return IteratorUtils.indexOf(IterableUtils.emptyIteratorIfNull(iterable), predicate);
    }

    public static <E> boolean matchesAll(Iterable<E> iterable, Predicate<? super E> predicate) {
        return IteratorUtils.matchesAll(IterableUtils.emptyIteratorIfNull(iterable), predicate);
    }

    public static <E> boolean matchesAny(Iterable<E> iterable, Predicate<? super E> predicate) {
        return IteratorUtils.matchesAny(IterableUtils.emptyIteratorIfNull(iterable), predicate);
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).isEmpty();
        }
        return IteratorUtils.isEmpty(IterableUtils.emptyIteratorIfNull(iterable));
    }

    public static <E> boolean contains(Iterable<E> iterable, Object object) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).contains(object);
        }
        return IteratorUtils.contains(IterableUtils.emptyIteratorIfNull(iterable), object);
    }

    public static <E> boolean contains(Iterable<? extends E> iterable, E object, Equator<? super E> equator) {
        if (equator == null) {
            throw new NullPointerException("Equator must not be null.");
        }
        return IterableUtils.matchesAny(iterable, EqualPredicate.equalPredicate(object, equator));
    }

    public static <T> T get(Iterable<T> iterable, int index) {
        CollectionUtils.checkIndexBounds(index);
        if (iterable instanceof List) {
            return (T)((List)iterable).get(index);
        }
        return IteratorUtils.get(IterableUtils.emptyIteratorIfNull(iterable), index);
    }

    public static <T> T first(Iterable<T> iterable) {
        return IterableUtils.get(iterable, 0);
    }

    public static int size(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        return IteratorUtils.size(IterableUtils.emptyIteratorIfNull(iterable));
    }

    public static <E> List<E> toList(Iterable<E> iterable) {
        return IteratorUtils.toList(IterableUtils.emptyIteratorIfNull(iterable));
    }

    public static <E> String toString(Iterable<E> iterable) {
        return IteratorUtils.toString(IterableUtils.emptyIteratorIfNull(iterable));
    }

    public static <E> String toString(Iterable<E> iterable, Transformer<? super E, String> transformer) {
        if (transformer == null) {
            throw new NullPointerException("Transformer must not be null.");
        }
        return IteratorUtils.toString(IterableUtils.emptyIteratorIfNull(iterable), transformer);
    }

    public static <E> String toString(Iterable<E> iterable, Transformer<? super E, String> transformer, String delimiter, String prefix, String suffix) {
        return IteratorUtils.toString(IterableUtils.emptyIteratorIfNull(iterable), transformer, delimiter, prefix, suffix);
    }

    static void checkNotNull(Iterable<?> iterable) {
        if (iterable == null) {
            throw new NullPointerException("Iterable must not be null.");
        }
    }

    static void checkNotNull(Iterable<?> ... iterables) {
        if (iterables == null) {
            throw new NullPointerException("Iterables must not be null.");
        }
        for (Iterable<?> iterable : iterables) {
            IterableUtils.checkNotNull(iterable);
        }
    }

    private static <E> Iterator<E> emptyIteratorIfNull(Iterable<E> iterable) {
        return iterable != null ? iterable.iterator() : IteratorUtils.emptyIterator();
    }
}

