/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.beanutils;

import com.feilong.lib.beanutils.PropertyUtils;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.collections4.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanToPropertyValueTransformer
implements Transformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanToPropertyValueTransformer.class);
    private String propertyName;
    private boolean ignoreNull;

    public BeanToPropertyValueTransformer(String propertyName) {
        this(propertyName, false);
    }

    public BeanToPropertyValueTransformer(String propertyName, boolean ignoreNull) {
        if (propertyName == null || propertyName.length() <= 0) {
            throw new IllegalArgumentException("propertyName cannot be null or empty");
        }
        this.propertyName = propertyName;
        this.ignoreNull = ignoreNull;
    }

    public Object transform(Object object) {
        Object propertyValue = null;
        try {
            propertyValue = PropertyUtils.getProperty(object, this.propertyName);
        }
        catch (IllegalArgumentException e) {
            String errorMsg = "Problem during transformation. Null value encountered in property path...";
            if (this.ignoreNull) {
                LOGGER.warn("WARNING: Problem during transformation. Null value encountered in property path..." + e);
            }
            IllegalArgumentException iae = new IllegalArgumentException("Problem during transformation. Null value encountered in property path...");
            throw iae;
        }
        catch (IllegalAccessException e) {
            String errorMsg = "Unable to access the property provided.";
            IllegalArgumentException iae = new IllegalArgumentException("Unable to access the property provided.");
            throw iae;
        }
        catch (InvocationTargetException e) {
            String errorMsg = "Exception occurred in property's getter";
            IllegalArgumentException iae = new IllegalArgumentException("Exception occurred in property's getter");
            throw iae;
        }
        catch (NoSuchMethodException e) {
            String errorMsg = "No property found for name [" + this.propertyName + "]";
            IllegalArgumentException iae = new IllegalArgumentException(errorMsg);
            throw iae;
        }
        return propertyValue;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean isIgnoreNull() {
        return this.ignoreNull;
    }
}

