/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.json.processor;

import com.feilong.core.lang.NumberUtil;
import com.feilong.json.processor.AbstractJsonValueProcessor;
import com.feilong.lib.json.JsonConfig;
import com.feilong.lib.json.processors.JsonValueProcessor;
import java.math.BigDecimal;

public class BigDecimalJsonValueProcessor
extends AbstractJsonValueProcessor {
    public static final JsonValueProcessor DEFAULT_INSTANCE = new BigDecimalJsonValueProcessor("#0.00");
    private String numberPattern = "#0.00";

    public BigDecimalJsonValueProcessor() {
    }

    public BigDecimalJsonValueProcessor(String numberPattern) {
        this.numberPattern = numberPattern;
    }

    @Override
    protected Object processValue(Object value, JsonConfig jsonConfig) {
        if (value == null) {
            return "";
        }
        return value instanceof BigDecimal ? NumberUtil.toString((Number)value, this.numberPattern) : value;
    }
}

