/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.json.builder;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.bean.PropertyUtil;
import com.feilong.core.lang.ClassUtil;
import com.feilong.core.util.CollectionsUtil;
import com.feilong.core.util.MapUtil;
import com.feilong.json.SensitiveWords;
import com.feilong.json.processor.SensitiveWordsJsonValueProcessor;
import com.feilong.lib.json.processors.JsonValueProcessor;
import com.feilong.lib.lang3.reflect.FieldUtils;
import com.feilong.lib.lang3.reflect.MethodUtils;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensitiveWordsPropertyNameAndJsonValueProcessorMapBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SensitiveWordsPropertyNameAndJsonValueProcessorMapBuilder.class);
    private static Map<Class<?>, Map<String, JsonValueProcessor>> cache = MapUtil.newHashMap();

    private SensitiveWordsPropertyNameAndJsonValueProcessorMapBuilder() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static Map<String, JsonValueProcessor> build(Object javaBean) {
        Validate.notNull(javaBean, "javaBean can't be null!", new Object[0]);
        if (ClassUtil.isInstance(javaBean, Map.class)) {
            return SensitiveWordsPropertyNameAndJsonValueProcessorMapBuilder.parseMap(javaBean);
        }
        if (ClassUtil.isInstance(javaBean, Iterable.class)) {
            return SensitiveWordsPropertyNameAndJsonValueProcessorMapBuilder.parseList(javaBean);
        }
        return SensitiveWordsPropertyNameAndJsonValueProcessorMapBuilder.parseBean(javaBean);
    }

    private static Map<String, JsonValueProcessor> parseList(Object inputMap) {
        Map<String, JsonValueProcessor> propertyNameAndJsonValueProcessorMap = MapUtil.newHashMap();
        Iterable list = (Iterable)inputMap;
        for (Object bean : list) {
            if (null == bean) continue;
            MapUtil.putAllIfNotNull(propertyNameAndJsonValueProcessorMap, SensitiveWordsPropertyNameAndJsonValueProcessorMapBuilder.parseBean(bean));
        }
        return propertyNameAndJsonValueProcessorMap;
    }

    private static Map<String, JsonValueProcessor> parseMap(Object inputMap) {
        Map<String, JsonValueProcessor> propertyNameAndJsonValueProcessorMap = MapUtil.newHashMap();
        Map map = (Map)inputMap;
        for (Map.Entry entry : map.entrySet()) {
            Object bean = entry.getValue();
            if (null == bean) continue;
            MapUtil.putAllIfNotNull(propertyNameAndJsonValueProcessorMap, SensitiveWordsPropertyNameAndJsonValueProcessorMapBuilder.parseBean(bean));
        }
        return propertyNameAndJsonValueProcessorMap;
    }

    private static Map<String, JsonValueProcessor> parseBean(Object javaBean) {
        Class<?> klass = javaBean.getClass();
        if (cache.containsKey(klass)) {
            return cache.get(klass);
        }
        Map<String, JsonValueProcessor> propertyNameAndJsonValueProcessorMap = SensitiveWordsPropertyNameAndJsonValueProcessorMapBuilder.build(klass);
        cache.put(klass, propertyNameAndJsonValueProcessorMap);
        return propertyNameAndJsonValueProcessorMap;
    }

    private static Map<String, JsonValueProcessor> build(Class<?> klass) {
        List<String> list = SensitiveWordsPropertyNameAndJsonValueProcessorMapBuilder.getWithAnnotationName(klass, SensitiveWords.class);
        Map<String, JsonValueProcessor> propertyNameAndJsonValueProcessorMap = MapUtil.newHashMap();
        for (String propertyName : list) {
            propertyNameAndJsonValueProcessorMap.put(propertyName, SensitiveWordsJsonValueProcessor.INSTANCE);
        }
        return propertyNameAndJsonValueProcessorMap;
    }

    private static <A extends Annotation> List<String> getWithAnnotationName(Class<?> klass, Class<A> annotationCls) {
        List<String> list = CollectionsUtil.newArrayList();
        CollectionsUtil.addAllIgnoreNull(list, SensitiveWordsPropertyNameAndJsonValueProcessorMapBuilder.getFiledNamesWithAnnotation(klass, annotationCls));
        CollectionsUtil.addAllIgnoreNull(list, SensitiveWordsPropertyNameAndJsonValueProcessorMapBuilder.getPropertyNamesWithAnnotation(klass, annotationCls));
        return list;
    }

    private static <A extends Annotation> List<String> getFiledNamesWithAnnotation(Class<?> klass, Class<A> annotationCls) {
        List<String> list = CollectionsUtil.newArrayList();
        List<Field> fieldsList = FieldUtils.getFieldsListWithAnnotation(klass, annotationCls);
        for (Field field : fieldsList) {
            list.add(field.getName());
        }
        return list;
    }

    private static <A extends Annotation> List<String> getPropertyNamesWithAnnotation(Class<?> klass, Class<A> annotationCls) {
        PropertyDescriptor[] propertyDescriptors = PropertyUtil.getPropertyDescriptors(klass);
        if (Validator.isNullOrEmpty(propertyDescriptors)) {
            return Collections.emptyList();
        }
        List<String> list = CollectionsUtil.newArrayList();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            Method readMethod = propertyDescriptor.getReadMethod();
            if (null == readMethod) {
                LOGGER.warn("class:[{}],property:[{}],has no ReadMethod!!SKIPPED", (Object)klass.getCanonicalName(), (Object)propertyDescriptor.getDisplayName());
                continue;
            }
            A sensitiveWords = MethodUtils.getAnnotation(readMethod, annotationCls, true, true);
            if (null == sensitiveWords) continue;
            list.add(propertyDescriptor.getName());
        }
        return list;
    }
}

