/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.json.builder;

import com.feilong.core.Validator;
import com.feilong.core.lang.ObjectUtil;
import com.feilong.core.util.MapUtil;
import com.feilong.json.JavaToJsonConfig;
import com.feilong.json.builder.SensitiveWordsPropertyNameAndJsonValueProcessorMapBuilder;
import com.feilong.lib.json.processors.JsonValueProcessor;
import java.util.Map;

public final class JavaToJsonConfigBuilder {
    private JavaToJsonConfigBuilder() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static JavaToJsonConfig buildUseJavaToJsonConfig(Object obj, JavaToJsonConfig javaToJsonConfig) {
        JavaToJsonConfig defaultJavaToJsonConfig = JavaToJsonConfigBuilder.buildDefaultJavaToJsonConfig(obj);
        if (Validator.isNullOrEmpty(javaToJsonConfig)) {
            return defaultJavaToJsonConfig;
        }
        if (null == defaultJavaToJsonConfig) {
            return javaToJsonConfig;
        }
        return JavaToJsonConfigBuilder.merge(defaultJavaToJsonConfig, javaToJsonConfig);
    }

    public static JavaToJsonConfig buildDefaultJavaToJsonConfig(Object javaBean) {
        Map<String, JsonValueProcessor> propertyNameAndJsonValueProcessorMap = SensitiveWordsPropertyNameAndJsonValueProcessorMapBuilder.build(javaBean);
        return Validator.isNullOrEmpty(propertyNameAndJsonValueProcessorMap) ? null : new JavaToJsonConfig(propertyNameAndJsonValueProcessorMap);
    }

    public static JavaToJsonConfig build(String[] excludes, String[] includes) {
        boolean noNeedBuild = Validator.isNullOrEmpty(excludes) && Validator.isNullOrEmpty(includes);
        return noNeedBuild ? null : new JavaToJsonConfig(excludes, includes);
    }

    private static JavaToJsonConfig merge(JavaToJsonConfig defaultJavaToJsonConfig, JavaToJsonConfig javaToJsonConfig) {
        Map<String, JsonValueProcessor> propertyNameAndJsonValueProcessorMap = ObjectUtil.defaultIfNullOrEmpty(javaToJsonConfig.getPropertyNameAndJsonValueProcessorMap(), MapUtil.newHashMap());
        MapUtil.putAllIfNotNull(propertyNameAndJsonValueProcessorMap, defaultJavaToJsonConfig.getPropertyNameAndJsonValueProcessorMap());
        javaToJsonConfig.setPropertyNameAndJsonValueProcessorMap(propertyNameAndJsonValueProcessorMap);
        return javaToJsonConfig;
    }
}

