/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.io;

import com.feilong.core.Validator;
import com.feilong.core.util.MapUtil;
import com.feilong.io.FilenameUtil;
import com.feilong.io.entity.MimeType;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.util.Map;

public final class MimeTypeUtil {
    private static final Map<String, String> FILE_EXTENSION_MAP = MapUtil.newHashMap();

    private MimeTypeUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static String getContentTypeByFileName(String fileName) {
        String extension = FilenameUtil.getExtension(fileName);
        if (Validator.isNullOrEmpty(extension)) {
            return "";
        }
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String contentType = fileNameMap.getContentTypeFor(fileName);
        return Validator.isNullOrEmpty(contentType) ? FILE_EXTENSION_MAP.get(extension.toLowerCase()) : contentType;
    }

    static {
        for (MimeType mimeType : MimeType.values()) {
            FILE_EXTENSION_MAP.put(mimeType.getExtension(), mimeType.getMime());
        }
    }
}

