/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.io;

import com.feilong.core.CharsetType;
import com.feilong.core.Validate;
import com.feilong.core.date.DateUtil;
import com.feilong.core.lang.ObjectUtil;
import com.feilong.io.FileUtil;
import com.feilong.io.IOUtil;
import com.feilong.io.InputStreamUtil;
import com.feilong.io.entity.FileWriteMode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOWriteUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(IOWriteUtil.class);
    public static final int DEFAULT_BUFFER_LENGTH = (int)(10L * FileUtil.ONE_KB);

    private IOWriteUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static void writeStringToFile(String filePath, String content, String charsetType) {
        IOWriteUtil.writeStringToFile(filePath, content, charsetType, FileWriteMode.COVER);
    }

    public static void writeStringToFile(String filePath, String content, String charsetType, FileWriteMode fileWriteMode) {
        Validate.notBlank(filePath, "filePath can't be null/empty!", new Object[0]);
        Date beginDate = DateUtil.now();
        String useEncode = ObjectUtil.defaultIfNullOrEmpty(charsetType, CharsetType.UTF8);
        FileWriteMode useFileWriteMode = ObjectUtil.defaultIfNullOrEmpty(fileWriteMode, FileWriteMode.COVER);
        FileUtil.createDirectoryByFilePath(filePath);
        InputStream inputStream = InputStreamUtil.newByteArrayInputStream(content, useEncode);
        FileOutputStream outputStream = FileUtil.getFileOutputStream(filePath, useFileWriteMode);
        IOWriteUtil.write(inputStream, outputStream);
        if (LOGGER.isInfoEnabled()) {
            File file = new File(filePath);
            String size = FileUtil.getFileFormatSize(file);
            String pattern = "fileWriteMode:[{}],encode:[{}],contentLength:[{}],fileSize:[{}],absolutePath:[{}],time:[{}]";
            String useTime = DateUtil.formatDuration(beginDate);
            LOGGER.info(pattern, new Object[]{useFileWriteMode, useEncode, content.length(), size, file.getAbsolutePath(), useTime});
        }
    }

    public static String write(InputStream inputStream, String directoryPath, String fileName) {
        Validate.notNull(inputStream, "inputStream can't be null!", new Object[0]);
        Validate.notBlank(directoryPath, "directoryPath can't be blank!", new Object[0]);
        Validate.notBlank(fileName, "fileName can't be blank!", new Object[0]);
        Date beginDate = DateUtil.now();
        Path path = Paths.get(directoryPath, fileName).normalize();
        String filePath = path.toString();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("directoryPath:[{}],fileName:[{}] ==> file final Path:[{}]", new Object[]{directoryPath, fileName, filePath});
        }
        FileUtil.createDirectoryByFilePath(filePath);
        FileOutputStream outputStream = FileUtil.getFileOutputStream(filePath);
        IOWriteUtil.write(inputStream, outputStream);
        if (LOGGER.isInfoEnabled()) {
            File file = new File(filePath);
            String messagePattern = "fileSize:[{}],absolutePath:[{}],use time:[{}]";
            LOGGER.info(messagePattern, new Object[]{FileUtil.getFileFormatSize(file), file.getAbsolutePath(), DateUtil.formatDuration(beginDate)});
        }
        return filePath;
    }

    public static void write(InputStream inputStream, OutputStream outputStream) {
        IOWriteUtil.write(inputStream, outputStream, DEFAULT_BUFFER_LENGTH);
    }

    public static void write(InputStream inputStream, OutputStream outputStream, int bufferLength) {
        IOWriteUtil.writeUseNIO(inputStream, outputStream, bufferLength);
    }

    private static void writeUseNIO(InputStream inputStream, OutputStream outputStream, int bufferLength) {
        Validate.notNull(inputStream, "inputStream can't be null!", new Object[0]);
        Validate.notNull(outputStream, "outputStream can't be null!", new Object[0]);
        Date beginDate = DateUtil.now();
        int loopCount = 0;
        int sumSize = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(bufferLength);
        try (ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
             WritableByteChannel writableByteChannel = Channels.newChannel(outputStream);){
            while (readableByteChannel.read(byteBuffer) != -1) {
                byteBuffer.flip();
                sumSize += writableByteChannel.write(byteBuffer);
                byteBuffer.clear();
                ++loopCount;
            }
            if (LOGGER.isDebugEnabled()) {
                String pattern = "Write data over,sumSize:[{}],bufferLength:[{}],loopCount:[{}],use time:[{}]";
                LOGGER.debug(pattern, new Object[]{FileUtil.formatSize(sumSize), bufferLength, loopCount, DateUtil.formatDuration(beginDate)});
            }
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(outputStream, inputStream);
                throw throwable;
            }
        }
        IOUtil.closeQuietly(outputStream, inputStream);
    }
}

