/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class IOUtil {
    public static final int EOF = -1;
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private IOUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static void closeQuietly(Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (Closeable closeable : closeables) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        long count = IOUtil.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    private static long copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        return IOUtil.copyLarge(input, output, new byte[bufferSize]);
    }

    private static long copyLarge(InputStream input, OutputStream output) throws IOException {
        return IOUtil.copy(input, output, 4096);
    }

    private static long copyLarge(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        int n;
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }
}

