/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.io;

import com.feilong.core.CharsetType;
import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.date.DateUtil;
import com.feilong.core.lang.ObjectUtil;
import com.feilong.core.util.CollectionsUtil;
import com.feilong.io.FileUtil;
import com.feilong.io.IOUtil;
import com.feilong.io.InputStreamUtil;
import com.feilong.io.LineNumberReaderResolver;
import com.feilong.io.ReaderConfig;
import com.feilong.json.JsonUtil;
import com.feilong.lib.lang3.StringUtils;
import com.feilong.validator.ValidatorUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOReaderUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(IOReaderUtil.class);
    private static final String DEFAULT_CHARSET_NAME = CharsetType.UTF8;

    private IOReaderUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static String readToString(String location) {
        return IOReaderUtil.readToString(location, DEFAULT_CHARSET_NAME);
    }

    public static String readToString(String location, String charsetName) {
        Validate.notBlank(location, "location can't be blank!", new Object[0]);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("will read location:[{}] to String,use charsetName:[{}]", (Object)location, (Object)charsetName);
        }
        InputStream inputStream = InputStreamUtil.getInputStream(location);
        return IOReaderUtil.readToString(inputStream, charsetName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readToString(File file, String charsetName) {
        Validate.notNull(file, "file can't be null!", new Object[0]);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("will read file:[{}] to String,use charsetName:[{}]", (Object)file.getAbsolutePath(), (Object)charsetName);
        }
        try (FileInputStream fileInputStream = FileUtil.getFileInputStream(file);){
            String string = IOReaderUtil.readToString(fileInputStream, charsetName);
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String readToString(FileInputStream fileInputStream, String charsetName) {
        String string;
        Validate.notNull(fileInputStream, "inputStream can't be null!", new Object[0]);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("start read fileInputStream:[{}] to String,use charsetName:[{}]", (Object)fileInputStream, (Object)charsetName);
        }
        Date beginDate = DateUtil.now();
        Charset charset = Charset.forName(ObjectUtil.defaultIfNullOrEmpty(charsetName, DEFAULT_CHARSET_NAME));
        int capacity = 186140;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(186140);
        FileChannel fileChannel = fileInputStream.getChannel();
        try {
            StringBuilder sb = new StringBuilder(186140);
            while (fileChannel.read(byteBuffer) != -1) {
                byteBuffer.flip();
                sb.append(charset.decode(byteBuffer));
                byteBuffer.clear();
            }
            String result = sb.toString();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("end read fileInputStream:[{}],use time: [{}]", (Object)fileInputStream, (Object)DateUtil.formatDuration(beginDate));
            }
            string = result;
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(fileInputStream);
                throw throwable;
            }
        }
        IOUtil.closeQuietly(fileInputStream);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readToString(InputStream inputStream, String charsetName) {
        String string;
        Validate.notNull(inputStream, "inputStream can't be null!", new Object[0]);
        Date beginDate = DateUtil.now();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("start read inputStream:[{}] to String,use charsetName:[{}]", (Object)inputStream, (Object)charsetName);
        }
        try {
            String result = InputStreamUtil.toString(inputStream, ObjectUtil.defaultIfNullOrEmpty(charsetName, DEFAULT_CHARSET_NAME));
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("end read inputStream:[{}],use time: [{}]", (Object)inputStream, (Object)DateUtil.formatDuration(beginDate));
            }
            string = result;
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtil.closeQuietly(inputStream);
        return string;
    }

    public static Set<String> readToSet(String location) {
        return IOReaderUtil.readToSet(location, null);
    }

    public static Set<String> readToSet(String location, ReaderConfig readerConfig) {
        Validate.notBlank(location, "location can't be blank!", new Object[0]);
        InputStream inputStream = InputStreamUtil.getInputStream(location);
        return IOReaderUtil.readToSet(InputStreamUtil.toBufferedReader(inputStream, CharsetType.UTF8), readerConfig);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<String> readToSet(File file, ReaderConfig readerConfig) {
        Validate.notNull(file, "file can't be null!", new Object[0]);
        try (FileReader reader = new FileReader(file);){
            Set<String> set = IOReaderUtil.readToSet(reader, readerConfig);
            return set;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Set<String> readToSet(Reader reader, ReaderConfig readerConfig) {
        Validate.notNull(reader, "reader can't be null!", new Object[0]);
        ReaderConfig useReaderConfig = ObjectUtil.defaultIfNull(readerConfig, ReaderConfig.DEFAULT);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("start read reader:[{}], readerConfig:[{}]", (Object)reader, (Object)JsonUtil.format(useReaderConfig));
        }
        Date beginDate = DateUtil.now();
        Set<String> set = CollectionsUtil.newLinkedHashSet();
        try (LineNumberReader lineNumberReader = new LineNumberReader(reader);){
            String line = null;
            while ((line = lineNumberReader.readLine()) != null) {
                if (useReaderConfig.getIsTrim()) {
                    line = StringUtils.trim(line);
                }
                if (IOReaderUtil.isIgnoreLine(line, useReaderConfig)) continue;
                set.add(line);
            }
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtil.closeQuietly(reader);
        if (LOGGER.isInfoEnabled()) {
            String format = "end read reader:[{}],readerConfig:[{}],use time: [{}]";
            LOGGER.info(format, new Object[]{reader, JsonUtil.format(useReaderConfig), DateUtil.formatDuration(beginDate)});
        }
        return set;
    }

    private static boolean isIgnoreLine(String line, ReaderConfig readerConfig) {
        String regexPattern = readerConfig.getRegexPattern();
        if (Validator.isNotNullOrEmpty(regexPattern) && !ValidatorUtil.isMatches(regexPattern, line)) {
            return true;
        }
        return Validator.isNullOrEmpty(line) && readerConfig.getIgnoreBlankLine();
    }

    public static void resolverFile(String location, LineNumberReaderResolver lineNumberReaderResolver) {
        Validate.notBlank(location, "location can't be blank!", new Object[0]);
        Validate.notNull(lineNumberReaderResolver, "lineNumberReaderResolver can't be null!", new Object[0]);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("will resolverFile location:[{}],use lineNumberReaderResolver:[{}]", (Object)location, (Object)lineNumberReaderResolver);
        }
        InputStream inputStream = InputStreamUtil.getInputStream(location);
        IOReaderUtil.resolverFile(InputStreamUtil.toBufferedReader(inputStream, CharsetType.UTF8), lineNumberReaderResolver);
    }

    public static void resolverFile(File file, LineNumberReaderResolver lineNumberReaderResolver) {
        Validate.notNull(file, "file can't be null!", new Object[0]);
        Validate.notNull(lineNumberReaderResolver, "lineNumberReaderResolver can't be null!", new Object[0]);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("will resolverFile file:[{}], lineNumberReaderResolver:[{}]", (Object)file.getAbsolutePath(), (Object)lineNumberReaderResolver);
        }
        try (FileReader reader = new FileReader(file);){
            IOReaderUtil.resolverFile(reader, lineNumberReaderResolver);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void resolverFile(Reader reader, LineNumberReaderResolver lineNumberReaderResolver) {
        Validate.notNull(reader, "reader can't be null!", new Object[0]);
        Validate.notNull(lineNumberReaderResolver, "lineNumberReaderResolver can't be null!", new Object[0]);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("start resolverFile reader:[{}], lineNumberReaderResolver:[{}]", (Object)reader, (Object)lineNumberReaderResolver);
        }
        Date beginDate = DateUtil.now();
        try (LineNumberReader lineNumberReader = new LineNumberReader(reader);){
            String line = null;
            while ((line = lineNumberReader.readLine()) != null) {
                int lineNumber = lineNumberReader.getLineNumber();
                boolean result = lineNumberReaderResolver.resolve(lineNumber, line);
                if (result) continue;
                break;
            }
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtil.closeQuietly(reader);
        if (LOGGER.isInfoEnabled()) {
            String format = "end resolverFile reader:[{}],lineNumberReaderResolver:[{}],use time: [{}]";
            LOGGER.info(format, new Object[]{reader, lineNumberReaderResolver, DateUtil.formatDuration(beginDate)});
        }
    }
}

