/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.io;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.lang.StringUtil;
import com.feilong.core.util.CollectionsUtil;
import com.feilong.io.FileUtil;
import com.feilong.lib.io.FilenameUtils;
import com.feilong.lib.lang3.StringUtils;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FilenameUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilenameUtil.class);
    private static final String[][] MICROSOFT_PC = new String[][]{{"\"", ""}, {":", ""}, {"*", ""}, {"?", ""}, {"<", ""}, {">", ""}, {"|", ""}};

    private FilenameUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static String getFormatFileName(String fileName) {
        String formatFileName = fileName;
        for (String[] arrayElement : MICROSOFT_PC) {
            String oldChar = arrayElement[0];
            if (!formatFileName.contains(oldChar)) continue;
            String newChar = arrayElement[1];
            LOGGER.warn("formatFileName:[{}] contains oldChar:[{}],will replace newChar:[{}]", new Object[]{formatFileName, oldChar, newChar});
            formatFileName = StringUtil.replace(formatFileName, oldChar, newChar);
        }
        return formatFileName;
    }

    public static String getFileName(String fileName) {
        Validate.notBlank(fileName, "fileName can't be blank!", new Object[0]);
        File file = new File(fileName);
        return file.getName();
    }

    public static String getFilePreName(String fileName) {
        return fileName.substring(0, fileName.lastIndexOf(46));
    }

    public static String getExtension(String fileName) {
        return StringUtils.defaultString(FilenameUtils.getExtension(fileName));
    }

    public static String getExtensionLowerCase(String fileName) {
        Validate.notBlank(fileName, "fileName can't be blank!", new Object[0]);
        return FilenameUtil.getExtension(fileName).toLowerCase();
    }

    public static String getNewFileName(String fileName, String newPostfixName) {
        Validate.notBlank(fileName, "fileName can't be null/empty!", new Object[0]);
        Validate.notBlank(newPostfixName, "newPostfixName can't be null/empty!", new Object[0]);
        if (FilenameUtil.hasExtension(fileName)) {
            return fileName.substring(0, fileName.lastIndexOf(46) + 1) + newPostfixName;
        }
        return fileName + "." + newPostfixName;
    }

    public static String getFileTopParentName(String pathname) {
        Validate.notBlank(pathname, "pathname can't be null/empty!", new Object[0]);
        String parent = FileUtil.getParent(pathname);
        if (Validator.isNullOrEmpty(parent)) {
            return pathname;
        }
        String fileTopParentName = FilenameUtil.getFileTopParentName(parent);
        LOGGER.debug("pathname:[{}],fileTopParentName:[{}]", (Object)pathname, (Object)fileTopParentName);
        return fileTopParentName;
    }

    public static String getFileTopParentName(File file) {
        Validate.notNull(file, "file can't be null!", new Object[0]);
        File parent = file.getParentFile();
        if (Validator.isNullOrEmpty(parent)) {
            String patch = file.getPath();
            LOGGER.debug("parent isNullOrEmpty,return file patch:{}", (Object)patch);
            return patch;
        }
        String fileTopParentName = FilenameUtil.getFileTopParentName(parent);
        LOGGER.debug("file.getAbsolutePath():[{}],fileTopParentName:[{}]", (Object)file.getAbsolutePath(), (Object)fileTopParentName);
        return fileTopParentName;
    }

    public static List<String> getParentPathList(String path) {
        Validate.notBlank(path, "path can't be blank!", new Object[0]);
        List<String> list = CollectionsUtil.newArrayList();
        FilenameUtil.resolverGetParentPath(path, list);
        return list;
    }

    private static void resolverGetParentPath(String path, List<String> list) {
        String parent = FileUtil.getParent(path);
        if (null != parent && Validator.isNotNullOrEmpty(parent = StringUtil.replace(parent, "\\", "/"))) {
            list.add(parent);
            FilenameUtil.resolverGetParentPath(parent, list);
        }
    }

    private static boolean hasExtension(String fileName) {
        return -1 != FilenameUtils.indexOfExtension(fileName);
    }
}

