/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.formatter.builder;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.util.SortUtil;
import com.feilong.core.util.comparator.BeanComparatorUtil;
import com.feilong.formatter.entity.BeanFormatterConfig;
import com.feilong.formatter.entity.FormatterColumnEntity;
import java.util.Comparator;
import java.util.List;

class FormatterColumnEntityListSorter {
    private static final Comparator<FormatterColumnEntity> CHAINED_COMPARATOR = BeanComparatorUtil.chainedComparator("order", "propertyName");

    private FormatterColumnEntityListSorter() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static List<FormatterColumnEntity> sortFormatterColumnEntityList(List<FormatterColumnEntity> formatterColumnEntityList, BeanFormatterConfig beanFormatterConfig) {
        Validate.notNull(beanFormatterConfig, "beanFormatterConfig can't be null!", new Object[0]);
        String[] sorts = beanFormatterConfig.getSorts();
        if (Validator.isNullOrEmpty(sorts)) {
            return SortUtil.sortList(formatterColumnEntityList, CHAINED_COMPARATOR);
        }
        Comparator propertyComparator = BeanComparatorUtil.propertyComparator("propertyName", sorts);
        return SortUtil.sortList(formatterColumnEntityList, propertyComparator, CHAINED_COMPARATOR);
    }
}

