/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.formatter;

import com.feilong.core.Validator;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.bean.PropertyUtil;
import com.feilong.core.util.CollectionsUtil;
import com.feilong.core.util.SortUtil;
import com.feilong.formatter.builder.FormatterBuilder;
import com.feilong.formatter.builder.FormatterBuilderFactory;
import com.feilong.formatter.entity.BeanFormatterConfig;
import com.feilong.formatter.entity.FormatterColumnEntity;
import com.feilong.json.JsonUtil;
import com.feilong.lib.collection4.IterableUtils;
import com.feilong.lib.lang3.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractFormatter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFormatter.class);

    AbstractFormatter() {
    }

    public <T> String format(T bean) {
        return Validator.isNullOrEmpty(bean) ? "" : this.format(PropertyUtil.describe(bean, new String[0]));
    }

    public <K, V> String format(Map<K, V> map) {
        if (Validator.isNullOrEmpty(map)) {
            return "";
        }
        int maxKeyLength = -1;
        for (K key : map.keySet()) {
            maxKeyLength = Math.max(maxKeyLength, StringUtils.length(ConvertUtil.toString(key)));
        }
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(map.size());
        Map<K, V> useMap = SortUtil.sortMapByKeyAsc(map);
        String separator = " : ";
        for (Map.Entry<K, V> entry : useMap.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            dataList.add(ConvertUtil.toArray(ConvertUtil.toString(key), separator, value));
        }
        return this.format(null, dataList);
    }

    public <T> String format(Iterable<T> iterable) {
        return this.format(iterable, null);
    }

    public <T> String format(Iterable<T> iterable, BeanFormatterConfig beanFormatterConfig) {
        if (Validator.isNullOrEmpty(iterable)) {
            return "";
        }
        T t = IterableUtils.get(iterable, 0);
        FormatterBuilder formatterBuilder = FormatterBuilderFactory.create(t);
        List<FormatterColumnEntity> formatterColumnEntityList = formatterBuilder.build(t, beanFormatterConfig);
        List<Object[]> dataList = AbstractFormatter.buildDataList(iterable, formatterColumnEntityList, formatterBuilder, beanFormatterConfig);
        return this.format(ConvertUtil.toStrings(CollectionsUtil.getPropertyValueList(formatterColumnEntityList, "name")), dataList);
    }

    private static <T> List<Object[]> buildDataList(Iterable<T> iterable, List<FormatterColumnEntity> formatterColumnEntityList, FormatterBuilder formatterBuilder, BeanFormatterConfig beanFormatterConfig) {
        List<String> propertyNameList = CollectionsUtil.getPropertyValueList(formatterColumnEntityList, "propertyName");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("propertyNameList:{}", (Object)JsonUtil.format(propertyNameList, 0, 0));
        }
        List<Object[]> dataList = CollectionsUtil.newArrayList();
        for (T bean : iterable) {
            CollectionsUtil.addIgnoreNullOrEmpty(dataList, formatterBuilder.buildLineData(bean, propertyNameList, beanFormatterConfig));
        }
        return dataList;
    }

    protected abstract String format(String[] var1, List<Object[]> var2);
}

