/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.excel.writer;

import com.feilong.core.Validate;
import com.feilong.excel.ExcelDefinition;
import com.feilong.excel.definition.ExcelSheet;
import com.feilong.excel.util.WorkbookUtil;
import com.feilong.excel.writer.FormulaEvaluatorUtil;
import com.feilong.excel.writer.SheetCopyer;
import com.feilong.excel.writer.SheetWriter;
import com.feilong.excel.writer.StyleMapBuilder;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class WorkbookWriter {
    private WorkbookWriter() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static void writePerSheet(Workbook workbook, OutputStream outputStream, ExcelDefinition definition, List<Map<String, Object>> beansList) {
        int i;
        List<ExcelSheet> excelSheets = definition.getExcelSheets();
        int numberOfSheets = workbook.getNumberOfSheets();
        int excelSheetsSize = excelSheets.size();
        WorkbookWriter.validate(excelSheetsSize, numberOfSheets);
        Map<String, CellStyle> styleMap = StyleMapBuilder.build(workbook, definition, excelSheets);
        for (i = numberOfSheets - 1; i > 0; --i) {
            workbook.removeSheetAt(i);
        }
        for (i = 0; i < beansList.size(); ++i) {
            Sheet newSheet = workbook.createSheet("Auto Generated Sheet " + i);
            SheetCopyer.copy(workbook.getSheetAt(0), newSheet);
            SheetWriter.write(newSheet, excelSheets.iterator().next(), styleMap, beansList.get(i));
        }
        workbook.removeSheetAt(0);
        WorkbookWriter.pack(workbook, outputStream);
    }

    public static void write(Workbook workbook, OutputStream outputStream, ExcelDefinition excelDefinition, Map<String, Object> beans) {
        List<ExcelSheet> excelSheets = excelDefinition.getExcelSheets();
        int excelSheetsSize = excelSheets.size();
        int numberOfSheets = workbook.getNumberOfSheets();
        WorkbookWriter.validate(excelSheetsSize, numberOfSheets);
        Map<String, CellStyle> styleMap = StyleMapBuilder.build(workbook, excelDefinition, excelSheets);
        for (int i = 0; i < excelSheetsSize; ++i) {
            SheetWriter.write(workbook.getSheetAt(i), excelSheets.get(i), styleMap, beans);
        }
        WorkbookWriter.pack(workbook, outputStream);
    }

    private static void validate(int excelSheetsSize, int numberOfSheets) {
        Validate.isTrue(excelSheetsSize > 0 && numberOfSheets >= excelSheetsSize, "No sheet definition found or Sheet Number in definition > number in excel template.", new Object[0]);
    }

    private static void pack(Workbook workbook, OutputStream outputStream) {
        FormulaEvaluatorUtil.reCalculate(workbook);
        workbook.setActiveSheet(0);
        WorkbookUtil.write(workbook, outputStream);
    }
}

