/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.excel.writer;

import com.feilong.core.Validate;
import com.feilong.core.date.DateUtil;
import com.feilong.excel.ExcelDefinition;
import com.feilong.excel.definition.ExcelSheet;
import com.feilong.excel.writer.ExcelCellConditionStyleInitializer;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StyleMapBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(StyleMapBuilder.class);

    private StyleMapBuilder() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static Map<String, CellStyle> build(Workbook workbook, ExcelDefinition excelDefinition, List<ExcelSheet> excelSheetList) {
        Integer styleSheetPosition = excelDefinition.getStyleSheetPosition();
        if (null == styleSheetPosition) {
            LOGGER.debug("ExcelDefinition styleSheetPosition is null, return empty styleMap");
            return Collections.emptyMap();
        }
        int excelSheetsSize = excelSheetList.size();
        Validate.isTrue(styleSheetPosition >= excelSheetsSize, "Style Sheet can not be one Template Sheet.", new Object[0]);
        Date beginDate = new Date();
        HashMap<String, CellStyle> styleMap = new HashMap<String, CellStyle>();
        Sheet sheet = workbook.getSheetAt(styleSheetPosition.intValue());
        for (int i = 0; i < excelSheetsSize; ++i) {
            ExcelSheet excelSheet = excelSheetList.get(i);
            styleMap.putAll(ExcelCellConditionStyleInitializer.init(sheet, excelSheet));
        }
        workbook.removeSheetAt(styleSheetPosition.intValue());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("buildStyleMap use time: [{}],StyleMap size:[{}]", (Object)DateUtil.formatDuration(beginDate), (Object)styleMap.size());
        }
        return styleMap;
    }
}

