/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.excel.writer;

import com.feilong.excel.definition.ExcelBlock;
import com.feilong.excel.definition.ExcelCell;
import com.feilong.excel.definition.ExcelCellConditionStyle;
import com.feilong.excel.definition.ExcelSheet;
import com.feilong.excel.util.CellReferenceUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExcelCellConditionStyleInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelCellConditionStyleInitializer.class);

    private ExcelCellConditionStyleInitializer() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static Map<String, CellStyle> init(Sheet sheet, ExcelSheet excelSheet) {
        HashMap<String, CellStyle> returnMap = new HashMap<String, CellStyle>();
        List<ExcelBlock> excelBlocks = excelSheet.getExcelBlocks();
        for (ExcelBlock excelBlock : excelBlocks) {
            ExcelCellConditionStyleInitializer.init(sheet, excelBlock, returnMap);
            ExcelBlock childBlock = excelBlock.getChildBlock();
            if (childBlock == null) continue;
            ExcelCellConditionStyleInitializer.init(sheet, childBlock, returnMap);
        }
        return returnMap;
    }

    private static void init(Sheet sheet, ExcelBlock excelBlock, Map<String, CellStyle> styleMap) {
        for (ExcelCellConditionStyle excelCellConditionStyle : excelBlock.getStyles()) {
            ExcelCellConditionStyleInitializer.init(sheet, excelCellConditionStyle, styleMap);
        }
        for (ExcelCell excelCell : excelBlock.getCells()) {
            for (ExcelCellConditionStyle excelCellConditionStyle : excelCell.getStyles()) {
                ExcelCellConditionStyleInitializer.init(sheet, excelCellConditionStyle, styleMap);
            }
        }
    }

    private static void init(Sheet sheet, ExcelCellConditionStyle excelCellConditionStyle, Map<String, CellStyle> styleMap) {
        int startRow = excelCellConditionStyle.getStartRow();
        int endRow = excelCellConditionStyle.getEndRow();
        int startCol = excelCellConditionStyle.getStartCol();
        int endCol = excelCellConditionStyle.getEndCol();
        String cellIndex = excelCellConditionStyle.getCellIndex();
        if (startRow == 0 && endRow == 0 && startCol == 0 && endCol == 0 && styleMap.containsKey(cellIndex)) {
            return;
        }
        int[] position = CellReferenceUtil.getCellPosition(cellIndex);
        int rows = endRow - startRow;
        int cols = endCol - startCol;
        for (int i = position[0]; i <= position[0] + rows; ++i) {
            Row row = sheet.getRow(i);
            if (row == null) {
                return;
            }
            for (int j = position[1]; j <= position[1] + cols; ++j) {
                Cell cell = row.getCell(j);
                if (cell == null) {
                    return;
                }
                String cellIndex2 = CellReferenceUtil.getCellRef(i, j);
                styleMap.put(cellIndex2, cell.getCellStyle());
                LOGGER.debug("Condition Style [{}]", (Object)cellIndex2);
            }
        }
    }
}

