/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.excel.writer;

import com.feilong.excel.util.CellReferenceUtil;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

class BlockStyleSetter {
    private BlockStyleSetter() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static void set(Sheet sheet, int startRowIndex, int endRowIndex, int startColumnIndex, int endColumnIndex, String cellIndex, Map<String, CellStyle> styleMap) {
        for (int rowIndex = startRowIndex; rowIndex <= endRowIndex; ++rowIndex) {
            Row row = sheet.getRow(rowIndex);
            if (row == null) {
                row = sheet.createRow(rowIndex);
            }
            for (int columnIndex = startColumnIndex; columnIndex <= endColumnIndex; ++columnIndex) {
                String cIdx = CellReferenceUtil.getCellRef(cellIndex, rowIndex - startRowIndex, columnIndex - startColumnIndex);
                CellStyle cellStyle = styleMap.get(cIdx);
                if (cellStyle == null) continue;
                Cell cell = row.getCell(columnIndex);
                if (cell == null) {
                    cell = row.createCell(columnIndex);
                }
                cell.setCellStyle(cellStyle);
            }
        }
    }
}

