/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.excel.writer;

import com.feilong.excel.definition.ExcelBlock;
import com.feilong.excel.writer.ColumnWriter;
import com.feilong.excel.writer.DataToCollectionUtil;
import com.feilong.lib.excel.ognl.OgnlStack;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BlockLoopVerticalWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockLoopVerticalWriter.class);

    private BlockLoopVerticalWriter() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static void write(Sheet sheet, ExcelBlock excelBlock, OgnlStack ognlStack, List<CellRangeAddress> mergedRegions, Map<String, CellStyle> styleMap) {
        try {
            Object value = ognlStack.getValue(excelBlock.getDataName());
            if (value == null) {
                return;
            }
            Collection<?> listValue = DataToCollectionUtil.convert(value);
            int endCol = excelBlock.getEndCol();
            int startCol = excelBlock.getStartCol();
            int step = 0;
            Object preObj = null;
            for (Object obj : listValue) {
                ognlStack.push(obj);
                ognlStack.addContext("preLine", preObj);
                ognlStack.addContext("lineNum", step - 1);
                int colOffset = step * (endCol - startCol + 1);
                ColumnWriter.write(sheet, excelBlock, ognlStack, 0, colOffset, mergedRegions, styleMap);
                ++step;
                preObj = ognlStack.pop();
            }
            ognlStack.removeContext("preLine");
            ognlStack.removeContext("lineNum");
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }
}

