/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.excel.writer;

import com.feilong.excel.writer.CellCoper;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BlockCopyer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockCopyer.class);

    private BlockCopyer() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static void copy(Sheet sheet, int startRow, int startCol, int endRow, int endCol, int rowOffset, int colOffset, List<CellRangeAddress> mergedRegions) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("will copy block,startRow:[{}],startCol:[{}],endRow:[{}],endCol:[{}],rowOffset:[{}],colOffset:[{}]", new Object[]{startRow, startCol, endRow, endCol, rowOffset, colOffset});
        }
        for (int row = startRow; row <= endRow; ++row) {
            Row oldRow = sheet.getRow(row);
            if (oldRow == null) continue;
            int newRowIndex = row + rowOffset;
            Row newRow = BlockCopyer.buildNewRow(sheet, oldRow, newRowIndex);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("copy row [{}] to [{}],Set new row height :{}", new Object[]{row, newRowIndex, Float.valueOf(newRow.getHeightInPoints())});
            }
            for (int col = startCol; col <= endCol; ++col) {
                Cell oldCell = oldRow.getCell(col);
                if (oldCell == null) continue;
                int newCellIndex = col + colOffset;
                Cell newCell = BlockCopyer.buildNewCell(newRow, newCellIndex);
                CellCoper.copy(oldCell, newCell, rowOffset, colOffset);
            }
        }
        for (int col = startCol; col <= endCol; ++col) {
            if (sheet.getColumnWidth(col) < 0) continue;
            sheet.setColumnWidth(col + colOffset, sheet.getColumnWidth(col));
        }
        if (mergedRegions != null) {
            for (CellRangeAddress cellRangeAddress : mergedRegions) {
                sheet.addMergedRegion(BlockCopyer.buildCellRangeAddress(rowOffset, colOffset, cellRangeAddress));
            }
        }
    }

    private static Cell buildNewCell(Row newRow, int newCellIndex) {
        Cell newCell = newRow.getCell(newCellIndex);
        if (newCell == null) {
            return newRow.createCell(newCellIndex);
        }
        return newCell;
    }

    private static Row buildNewRow(Sheet sheet, Row oldRow, int newRowIndex) {
        Row newRow = sheet.getRow(newRowIndex);
        if (newRow == null) {
            newRow = sheet.createRow(newRowIndex);
        }
        if (oldRow.getHeight() >= 0) {
            newRow.setHeight(oldRow.getHeight());
        }
        return newRow;
    }

    private static CellRangeAddress buildCellRangeAddress(int rowOffset, int colOffset, CellRangeAddress cellRangeAddress) {
        return new CellRangeAddress(cellRangeAddress.getFirstRow() + rowOffset, cellRangeAddress.getLastRow() + rowOffset, cellRangeAddress.getFirstColumn() + colOffset, cellRangeAddress.getLastColumn() + colOffset);
    }
}

