/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.excel.reader;

import com.feilong.core.Validate;
import com.feilong.excel.DataConvertorConfig;
import com.feilong.excel.definition.ExcelCell;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.Map;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PropertyTypeDetector {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyTypeDetector.class);

    private PropertyTypeDetector() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static Class<?> detect(Object object, ExcelCell excelCell) throws Exception {
        Validate.notNull(object, "object can't be null!", new Object[0]);
        String type = excelCell.getType();
        Class<?> clazz = DataConvertorConfig.getInstance().getSupportedClass(type);
        if (clazz != null) {
            return clazz;
        }
        String dataName = excelCell.getDataName();
        return PropertyTypeDetector.detect(object, dataName);
    }

    private static Class<?> detect(Object object, String dataName) throws Exception {
        if (object instanceof Map) {
            LOGGER.debug("detect for Map[{}] with Key {}.", object, (Object)dataName);
            Map map = (Map)object;
            int delim = dataName.indexOf(46);
            if (delim > 0) {
                return PropertyTypeDetector.detect(map.get(dataName.substring(0, delim)), dataName.substring(delim + 1));
            }
            return map.get(dataName).getClass();
        }
        LOGGER.trace("getPropertyType [{}] property {}.", object, (Object)dataName);
        return PropertyTypeDetector.getPropertyTypeWithClass(object.getClass(), dataName);
    }

    private static Class<? extends Object> getPropertyTypeWithClass(Class<? extends Object> clazz, String dataName) throws Exception {
        Validate.notNull(clazz, "clazz can't be null!", new Object[0]);
        int delim = dataName.indexOf(46);
        if (delim < 0) {
            return PropertyTypeDetector.extracted(clazz, dataName);
        }
        Class<?> propertyType = PropertyTypeDetector.extracted(clazz, dataName.substring(0, delim));
        return PropertyTypeDetector.getPropertyTypeWithClass(propertyType, dataName.substring(delim + 1));
    }

    private static Class<?> extracted(Class<?> clazz, String dataName) throws IntrospectionException, OgnlException {
        PropertyDescriptor propertyDescriptor = OgnlRuntime.getPropertyDescriptor(clazz, (String)dataName);
        Validate.notNull(propertyDescriptor, "propertyDescriptor can't be null!", new Object[0]);
        return propertyDescriptor.getPropertyType();
    }
}

