/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.excel.reader;

import com.feilong.excel.util.CellReferenceUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CellValueGetter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CellValueGetter.class);

    private CellValueGetter() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static Object get(Cell cell, FormulaEvaluator formulaEvaluator) {
        if (cell == null) {
            return null;
        }
        Object value = null;
        CellValue cellValue = formulaEvaluator.evaluate(cell);
        if (cellValue == null) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("{}: null", (Object)CellReferenceUtil.getCellRef(cell.getRowIndex(), cell.getColumnIndex()));
            }
            return null;
        }
        switch (cellValue.getCellType()) {
            case BLANK: 
            case ERROR: {
                break;
            }
            case BOOLEAN: {
                value = cellValue.getBooleanValue();
                break;
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    value = DateUtil.getJavaDate((double)cellValue.getNumberValue());
                    break;
                }
                value = cellValue.getNumberValue();
                break;
            }
            case STRING: {
                value = cellValue.getStringValue();
                break;
            }
            default: {
                throw new UnsupportedOperationException("default not support!");
            }
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{}: {}", (Object)CellReferenceUtil.getCellRef(cell.getRowIndex(), cell.getColumnIndex()), value);
        }
        return value;
    }
}

