/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.excel.reader;

import com.feilong.excel.definition.LoopBreakCondition;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

class BlockReaderLoopBreaker {
    private BlockReaderLoopBreaker() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static boolean checkBreak(Sheet sheet, int rowIndex, int columnIndex, LoopBreakCondition loopBreakCondition) {
        if (sheet.getLastRowNum() < rowIndex) {
            return true;
        }
        if (loopBreakCondition != null) {
            Row row = sheet.getRow(rowIndex + loopBreakCondition.getRowOffset());
            if (row == null) {
                return false;
            }
            Cell cell = row.getCell(columnIndex + loopBreakCondition.getColOffset());
            if (cell == null || cell.getCellType() != CellType.STRING) {
                return false;
            }
            if (loopBreakCondition.getFlagString().equals(cell.getRichStringCellValue().getString())) {
                return true;
            }
        }
        return false;
    }
}

