/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.excel.reader;

import com.feilong.core.Validator;
import com.feilong.excel.ExcelException;
import com.feilong.excel.definition.ExcelBlock;
import com.feilong.excel.definition.ExcelCell;
import com.feilong.excel.definition.LoopBreakCondition;
import com.feilong.excel.reader.BlockReaderLoopBreaker;
import com.feilong.excel.reader.CellValueConverter;
import com.feilong.excel.reader.CellValueGetter;
import com.feilong.excel.reader.PropertyTypeDetector;
import com.feilong.excel.reader.ReadStatus;
import com.feilong.excel.util.CellReferenceUtil;
import com.feilong.lib.excel.ognl.OgnlStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BlockReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockReader.class);
    private static final int STATUS_SETTING_ERROR = 2;
    private static final int STATUS_SYSTEM_ERROR = 5;
    private static final int STATUS_DATA_COLLECTION_ERROR = 10;

    private BlockReader() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static void readLoopBlock(Workbook workbook, int sheetNo, ExcelBlock excelBlock, OgnlStack ognlStack, ReadStatus readStatus) {
        String dataName = excelBlock.getDataName();
        if (Validator.isNullOrEmpty(dataName)) {
            readStatus.setStatus(2);
            readStatus.setMessage("dataName for block[" + excelBlock.toString() + "] is not set");
            return;
        }
        try {
            Collection<Object> dataList;
            Object obj = ognlStack.getValue(dataName);
            if (obj == null) {
                dataList = new ArrayList();
                ognlStack.setValue(dataName, dataList);
            } else {
                if (!(obj instanceof Collection)) {
                    readStatus.setStatus(2);
                    readStatus.setMessage("Property " + dataName + " is not a Collection");
                    return;
                }
                dataList = (Collection)obj;
            }
            int startRow = excelBlock.getStartRow();
            int step = excelBlock.getEndRow() - excelBlock.getStartRow() + 1;
            LoopBreakCondition loopBreakCondition = excelBlock.getBreakCondition();
            int startCol = excelBlock.getStartCol();
            while (!BlockReaderLoopBreaker.checkBreak(workbook.getSheetAt(sheetNo), startRow, startCol, loopBreakCondition)) {
                Object value = BlockReader.readBlock(workbook, sheetNo, excelBlock, startRow, readStatus);
                dataList.add(value);
                startRow += step;
            }
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            readStatus.setStatus(5);
            readStatus.setMessage(e.getMessage());
        }
    }

    static Object readBlock(Workbook workbook, int sheetNo, ExcelBlock excelBlock, int startRow, ReadStatus readStatus) throws Exception {
        Sheet sheet = workbook.getSheetAt(sheetNo);
        FormulaEvaluator formulaEvaluator = workbook.getCreationHelper().createFormulaEvaluator();
        if (excelBlock.getLoopClass() == null) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (ExcelCell cellDefinition : excelBlock.getCells()) {
                int rowOffSet = cellDefinition.getRow() - excelBlock.getStartRow();
                Row row = sheet.getRow(startRow + rowOffSet);
                Cell cell = row == null ? null : row.getCell(cellDefinition.getCol());
                try {
                    Object value = CellValueGetter.get(cell, formulaEvaluator);
                    value = CellValueConverter.convert(sheetNo, CellReferenceUtil.getCellRef(startRow + rowOffSet, cellDefinition.getCol()), value, cellDefinition, PropertyTypeDetector.detect(result, cellDefinition));
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("{}[Checked]:{}", (Object)CellReferenceUtil.getCellRef(startRow + rowOffSet, cellDefinition.getCol()), value);
                    }
                    result.put(cellDefinition.getDataName(), value);
                }
                catch (ExcelException e) {
                    if (readStatus.getStatus() == 0) {
                        readStatus.setStatus(10);
                    }
                    readStatus.addException(e);
                }
            }
            return result;
        }
        Object result = excelBlock.getLoopClass().newInstance();
        OgnlStack ognlStack = new OgnlStack(result);
        for (ExcelCell excelCell : excelBlock.getCells()) {
            int rowOffSet = excelCell.getRow() - excelBlock.getStartRow();
            Row row = sheet.getRow(startRow + rowOffSet);
            int col = excelCell.getCol();
            Cell cell = row == null ? null : row.getCell(col);
            try {
                Object value = CellValueGetter.get(cell, formulaEvaluator);
                value = CellValueConverter.convert(sheetNo, CellReferenceUtil.getCellRef(startRow + rowOffSet, col), value, excelCell, PropertyTypeDetector.detect(result, excelCell));
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("{}[Checked]:{}", (Object)CellReferenceUtil.getCellRef(startRow + rowOffSet, col), value);
                }
                ognlStack.setValue(excelCell.getDataName(), value);
            }
            catch (ExcelException e) {
                if (readStatus.getStatus() == 0) {
                    readStatus.setStatus(10);
                }
                readStatus.addException(e);
            }
        }
        return result;
    }

    static void readSimpleBlock(Workbook workbook, int sheetNo, ExcelBlock excelBlock, OgnlStack ognlStack, ReadStatus readStatus) {
        Sheet sheet = workbook.getSheetAt(sheetNo);
        FormulaEvaluator formulaEvaluator = workbook.getCreationHelper().createFormulaEvaluator();
        for (ExcelCell excelCell : excelBlock.getCells()) {
            Row row = sheet.getRow(excelCell.getRow());
            Cell cell = row == null ? null : row.getCell(excelCell.getCol());
            try {
                Object value = CellValueGetter.get(cell, formulaEvaluator);
                Class<?> propertyType = PropertyTypeDetector.detect(ognlStack.peek(), excelCell);
                value = CellValueConverter.convert(sheetNo, CellReferenceUtil.getCellRef(excelCell.getRow(), excelCell.getCol()), value, excelCell, propertyType);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{}[Checked]:{}", (Object)CellReferenceUtil.getCellRef(excelCell.getRow(), excelCell.getCol()), value);
                }
                ognlStack.setValue(excelCell.getDataName(), value);
            }
            catch (ExcelException e) {
                if (readStatus.getStatus() == 0) {
                    readStatus.setStatus(10);
                }
                readStatus.addException(e);
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
                readStatus.setStatus(5);
                readStatus.setMessage(e.getMessage());
            }
        }
    }
}

