/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.util.predicate;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.bean.PropertyUtil;
import com.feilong.core.lang.ArrayUtil;
import com.feilong.core.util.equator.IgnoreCaseEquator;
import com.feilong.core.util.predicate.BeanPredicate;
import com.feilong.lib.collection4.ComparatorUtils;
import com.feilong.lib.collection4.PredicateUtils;
import com.feilong.lib.collection4.functors.ComparatorPredicate;
import com.feilong.lib.collection4.functors.EqualPredicate;
import com.feilong.lib.lang3.ArrayUtils;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import org.apache.commons.collections4.Predicate;

public final class BeanPredicateUtil {
    private BeanPredicateUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static <T, V> Predicate<T> equalPredicate(String propertyName, V propertyValue) {
        Validate.notBlank(propertyName, "propertyName can't be blank!", new Object[0]);
        return new BeanPredicate(propertyName, PredicateUtils.equalPredicate(propertyValue));
    }

    public static <T> Predicate<T> equalIgnoreCasePredicate(String propertyName, String propertyValue) {
        Validate.notBlank(propertyName, "propertyName can't be blank!", new Object[0]);
        return new BeanPredicate(propertyName, EqualPredicate.equalPredicate(propertyValue, IgnoreCaseEquator.INSTANCE));
    }

    public static <T> Predicate<T> equalPredicate(Map<String, ?> propertyNameAndPropertyValueMap) {
        Validate.notEmpty(propertyNameAndPropertyValueMap, "propertyNameAndPropertyValueMap can't be null!", new Object[0]);
        BeanPredicate[] beanPredicates = ArrayUtil.newArray(BeanPredicate.class, propertyNameAndPropertyValueMap.size());
        int index = 0;
        for (Map.Entry<String, ?> entry : propertyNameAndPropertyValueMap.entrySet()) {
            String propertyName = entry.getKey();
            Object propertyValue = entry.getValue();
            Validate.notBlank(propertyName, "propertyName can't be blank!", new Object[0]);
            Array.set(beanPredicates, index, BeanPredicateUtil.equalPredicate(propertyName, propertyValue));
            ++index;
        }
        return PredicateUtils.allPredicate(beanPredicates);
    }

    public static <T> Predicate<T> equalPredicate(T bean, String ... propertyNames) {
        if (null == bean) {
            return PredicateUtils.nullPredicate();
        }
        Map<String, Object> propertyNameAndPropertyValueMap = PropertyUtil.describe(bean, propertyNames);
        return BeanPredicateUtil.equalPredicate(propertyNameAndPropertyValueMap);
    }

    @SafeVarargs
    public static <T, V> Predicate<T> containsPredicate(String propertyName, V ... propertyValues) {
        Validate.notBlank(propertyName, "propertyName can't be blank!", new Object[0]);
        return new BeanPredicate(propertyName, propertyValue -> ArrayUtils.contains(propertyValues, propertyValue));
    }

    public static <T, V> Predicate<T> containsPredicate(String propertyName, final Collection<V> propertyValueList) {
        Validate.notBlank(propertyName, "propertyName can't be blank!", new Object[0]);
        return new BeanPredicate(propertyName, new Predicate<V>(){

            @Override
            public boolean evaluate(V propertyValue) {
                return Validator.isNotNullOrEmpty(propertyValueList) && propertyValueList.contains(propertyValue);
            }
        });
    }

    public static <T, V extends Comparable<? super V>> Predicate<T> comparatorPredicate(String propertyName, V valueToCompare, ComparatorPredicate.Criterion criterion) {
        Validate.notBlank(propertyName, "propertyName can't be blank!", new Object[0]);
        return BeanPredicateUtil.comparatorPredicate(propertyName, valueToCompare, ComparatorUtils.naturalComparator(), criterion);
    }

    public static <T, V extends Comparable<? super V>> Predicate<T> comparatorPredicate(String propertyName, V valueToCompare, Comparator<V> comparator, ComparatorPredicate.Criterion criterion) {
        Validate.notBlank(propertyName, "propertyName can't be blank!", new Object[0]);
        return new BeanPredicate(propertyName, new ComparatorPredicate<V>(valueToCompare, comparator, criterion));
    }
}

