/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.util.comparator;

import com.feilong.core.Validate;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.lang.StringUtil;
import com.feilong.tools.slf4j.Slf4jUtil;

public final class SortHelper {
    private static final String ASC = "ASC";
    private static final String DESC = "DESC";

    private SortHelper() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static String[] parsePropertyNameAndOrder(String propertyNameAndOrder) {
        Validate.notBlank(propertyNameAndOrder, "propertyNameAndOrder can't be blank!", new Object[0]);
        String[] array = StringUtil.tokenizeToStringArray(propertyNameAndOrder.trim(), " ");
        if (array.length > 2) {
            String message = Slf4jUtil.format("propertyNameAndOrder:[{}] has more than 1 space,must max 1 space", propertyNameAndOrder);
            throw new IllegalArgumentException(message);
        }
        String order = null;
        if (array.length == 2 && !(order = array[1]).equalsIgnoreCase(ASC) && !order.equalsIgnoreCase(DESC)) {
            String pattern = "propertyNameAndOrder:[{}] 's order:[{}] must ignoreCase equals [asc or desc]";
            throw new IllegalArgumentException(Slf4jUtil.format(pattern, propertyNameAndOrder, order));
        }
        return ConvertUtil.toArray(array[0], order);
    }

    public static boolean isAsc(String[] propertyNameAndOrderArray) {
        Validate.notEmpty(propertyNameAndOrderArray, "propertyNameAndOrderArray can't be null/empty!", new Object[0]);
        Validate.isTrue(2 == propertyNameAndOrderArray.length, "propertyNameAndOrderArray.length must 2, but length is:[%s],propertyNameAndOrderArray:[%s]", propertyNameAndOrderArray.length, propertyNameAndOrderArray);
        String order = propertyNameAndOrderArray[1];
        Validate.isTrue(null == order || ASC.equalsIgnoreCase(order) || DESC.equalsIgnoreCase(order), "order value must one of [null/ASC/DESC], but is:[%s],propertyNameAndOrderArray:[%s]", order, propertyNameAndOrderArray);
        return null == order || ASC.equalsIgnoreCase(order);
    }
}

