/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.util.comparator;

import com.feilong.core.Validate;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.bean.PropertyUtil;
import com.feilong.core.lang.ClassUtil;
import com.feilong.lib.lang3.ObjectUtils;
import java.io.Serializable;
import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyComparator<T>
implements Comparator<T>,
Serializable {
    private static final long serialVersionUID = -3159374167882773300L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyComparator.class);
    private final String propertyName;
    private Comparator comparator;
    private Class<? extends Comparable> propertyValueConvertToClass;

    public PropertyComparator(String propertyName) {
        Validate.notBlank(propertyName, "propertyName can't be blank!", new Object[0]);
        this.propertyName = propertyName;
        LOGGER.trace("propertyName:[{}]", (Object)propertyName);
    }

    public PropertyComparator(String propertyName, Comparator comparator) {
        Validate.notBlank(propertyName, "propertyName can't be blank!", new Object[0]);
        this.propertyName = propertyName;
        this.comparator = comparator;
        LOGGER.trace("propertyName:[{}],comparator:[{}]", (Object)propertyName, (Object)comparator);
    }

    public PropertyComparator(String propertyName, Class<? extends Comparable> propertyValueConvertToClass) {
        Validate.notBlank(propertyName, "propertyName can't be blank!", new Object[0]);
        this.propertyName = propertyName;
        this.propertyValueConvertToClass = propertyValueConvertToClass;
        LOGGER.trace("propertyName:[{}],propertyValueConvertToClass:[{}]", (Object)propertyName, propertyValueConvertToClass);
    }

    public PropertyComparator(String propertyName, Class<? extends Comparable> propertyValueConvertToClass, Comparator comparator) {
        Validate.notBlank(propertyName, "propertyName can't be blank!", new Object[0]);
        this.propertyName = propertyName;
        this.propertyValueConvertToClass = propertyValueConvertToClass;
        this.comparator = comparator;
        LOGGER.trace("propertyName:[{}]", (Object)propertyName);
    }

    @Override
    public int compare(T t1, T t2) {
        if (t1 == t2) {
            return 0;
        }
        if (null == t1) {
            return 1;
        }
        if (null == t2) {
            return -1;
        }
        Comparable propertyValue1 = (Comparable)PropertyUtil.getProperty(t1, this.propertyName);
        Comparable propertyValue2 = (Comparable)PropertyUtil.getProperty(t2, this.propertyName);
        if (null != this.propertyValueConvertToClass) {
            propertyValue1 = ConvertUtil.convert(propertyValue1, this.propertyValueConvertToClass);
            propertyValue2 = ConvertUtil.convert(propertyValue2, this.propertyValueConvertToClass);
        }
        return null == this.comparator ? this.compare(t1, t2, propertyValue1, propertyValue2) : this.comparator.compare(propertyValue1, propertyValue2);
    }

    private int compare(T t1, T t2, Comparable propertyValue1, Comparable propertyValue2) {
        boolean nullPropertyValueGreater = false;
        int compareTo = ObjectUtils.compare(propertyValue1, propertyValue2, nullPropertyValueGreater);
        if (0 != compareTo) {
            String pattern = "propertyName:[{}],propertyValue1:[{}],propertyValue2:[{}],result:[{}]";
            LOGGER.trace(pattern, new Object[]{this.propertyName, propertyValue1, propertyValue2, compareTo});
            return compareTo;
        }
        return this.compareWithSameValue(t1, t2);
    }

    private int compareWithSameValue(T t1, T t2) {
        return ClassUtil.isInstance(t1, Comparable.class) ? ObjectUtils.compare((Comparable)t1, (Comparable)t2) : ObjectUtils.compare(t1.hashCode(), t2.hashCode());
    }
}

