/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.util.closure;

import com.feilong.core.Validate;
import com.feilong.core.bean.PropertyUtil;
import org.apache.commons.collections4.Closure;

public class BeanPropertyValueChangeClosure<T>
implements Closure<T> {
    private final String propertyName;
    private final Object propertyValue;

    public BeanPropertyValueChangeClosure(String propertyName, Object propertyValue) {
        Validate.notBlank(propertyName, "propertyName can't be blank!", new Object[0]);
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
    }

    @Override
    public void execute(T input) {
        if (null == input) {
            return;
        }
        PropertyUtil.setProperty(input, this.propertyName, this.propertyValue);
    }
}

