/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.util;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.util.comparator.BeanComparatorUtil;
import com.feilong.core.util.comparator.ComparatorUtil;
import com.feilong.core.util.comparator.PropertyComparator;
import com.feilong.lib.collection4.ComparatorUtils;
import com.feilong.lib.collection4.comparators.ReverseComparator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public final class SortUtil {
    private SortUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static <T> T[] sortArray(T[] arrays) {
        if (null == arrays) {
            return ConvertUtil.toArray(new Object[0]);
        }
        Arrays.sort(arrays);
        return arrays;
    }

    @SafeVarargs
    public static <T> T[] sortArray(T[] arrays, Comparator<T> ... comparators) {
        if (null == arrays) {
            return ConvertUtil.toArray(new Object[0]);
        }
        if (Validator.isNullOrEmpty(comparators)) {
            return arrays;
        }
        Arrays.sort(arrays, SortUtil.toComparator(comparators));
        return arrays;
    }

    public static <T extends Comparable<? super T>> List<T> sortList(List<T> list) {
        if (null == list) {
            return Collections.emptyList();
        }
        Collections.sort(list);
        return list;
    }

    @SafeVarargs
    public static <T extends Comparable<? super T>> List<T> sortListByFixedOrderArray(List<T> list, T ... fixedOrderItems) {
        return SortUtil.sortListByFixedOrderList(list, ConvertUtil.toList(fixedOrderItems));
    }

    public static <T extends Comparable<? super T>> List<T> sortListByFixedOrderList(List<T> list, List<T> fixedOrderItemList) {
        if (null == list) {
            return Collections.emptyList();
        }
        if (Validator.isNullOrEmpty(list)) {
            return list;
        }
        if (Validator.isNullOrEmpty(fixedOrderItemList)) {
            return list;
        }
        return SortUtil.sortList(list, ComparatorUtil.buildFixedOrderComparator(fixedOrderItemList));
    }

    @SafeVarargs
    public static <O> List<O> sortList(List<O> list, Comparator<O> ... comparators) {
        if (null == list) {
            return Collections.emptyList();
        }
        if (Validator.isNullOrEmpty(comparators)) {
            return list;
        }
        Collections.sort(list, SortUtil.toComparator(comparators));
        return list;
    }

    @SafeVarargs
    private static <O> Comparator<O> toComparator(Comparator<O> ... comparators) {
        return 1 == comparators.length ? comparators[0] : ComparatorUtils.chainedComparator(comparators);
    }

    public static <O> List<O> sortListByPropertyNamesValue(List<O> list, String ... propertyNameAndOrders) {
        if (null == list) {
            return Collections.emptyList();
        }
        Validate.notEmpty(propertyNameAndOrders, "propertyNameAndOrders can't be null/empty!", new Object[0]);
        Validate.noNullElements(propertyNameAndOrders, "propertyNameAndOrders:[%s] has empty value", (Object[])propertyNameAndOrders);
        Comparator comparator = BeanComparatorUtil.chainedComparator(propertyNameAndOrders);
        return SortUtil.sortList(list, comparator);
    }

    @SafeVarargs
    public static <O, V> List<O> sortListByFixedOrderPropertyValueArray(List<O> list, String propertyName, V ... propertyValues) {
        if (null == list) {
            return Collections.emptyList();
        }
        Validate.notBlank(propertyName, "propertyName can't be blank!", new Object[0]);
        Comparator propertyComparator = BeanComparatorUtil.propertyComparator(propertyName, propertyValues);
        return SortUtil.sortList(list, propertyComparator);
    }

    public static <O, V> List<O> sortListByFixedOrderPropertyValueList(List<O> list, String propertyName, List<V> propertyValues) {
        if (null == list) {
            return Collections.emptyList();
        }
        Validate.notBlank(propertyName, "propertyName can't be blank!", new Object[0]);
        Comparator propertyComparator = BeanComparatorUtil.propertyComparator(propertyName, propertyValues);
        return SortUtil.sortList(list, propertyComparator);
    }

    public static <K, V> Map<K, V> sortMapByKeyAsc(Map<K, V> map) {
        if (null == map) {
            return Collections.emptyMap();
        }
        return SortUtil.sortMap(map, new PropertyComparator<Map.Entry<K, V>>("key"));
    }

    public static <K, V> Map<K, V> sortMapByKeyDesc(Map<K, V> map) {
        if (null == map) {
            return Collections.emptyMap();
        }
        return SortUtil.sortMap(map, new ReverseComparator<Map.Entry<K, V>>(new PropertyComparator("key")));
    }

    public static <K, V> Map<K, V> sortMapByKeyFixOrder(Map<K, V> map, K ... keys) {
        if (null == map) {
            return Collections.emptyMap();
        }
        if (Validator.isNullOrEmpty(keys)) {
            return map;
        }
        Comparator<Map.Entry<K, V>> propertyComparator = BeanComparatorUtil.propertyComparator("key", keys);
        return SortUtil.sortMap(map, propertyComparator);
    }

    public static <K, V extends Comparable<V>> Map<K, V> sortMapByValueAsc(Map<K, V> map) {
        if (null == map) {
            return Collections.emptyMap();
        }
        return SortUtil.sortMap(map, new PropertyComparator<Map.Entry<K, V>>("value"));
    }

    public static <K, V extends Comparable<V>> Map<K, V> sortMapByValueDesc(Map<K, V> map) {
        if (null == map) {
            return Collections.emptyMap();
        }
        return SortUtil.sortMap(map, new ReverseComparator<Map.Entry<K, V>>(new PropertyComparator("value")));
    }

    public static <K, V> Map<K, V> sortMap(Map<K, V> map, Comparator<Map.Entry<K, V>> mapEntryComparator) {
        if (null == map) {
            return Collections.emptyMap();
        }
        Validate.notNull(mapEntryComparator, "mapEntryComparator can't be null!", new Object[0]);
        List<Map.Entry<K, V>> mapEntryList = ConvertUtil.toList(map.entrySet());
        return ConvertUtil.toMap(SortUtil.sortList(mapEntryList, mapEntryComparator));
    }
}

